/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.handler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.wsf.common.handler.GenericSOAPHandler;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.trust.jbossws.Constants;
import org.picketlink.trust.jbossws.Util;
import org.picketlink.trust.jbossws.handler.SecurityActions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPicketLinkTrustHandler
extends GenericSOAPHandler {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected static Set<QName> headers;
    protected static final String SEC_MGR_LOOKUP = "java:comp/env/security/securityMgr";
    protected static final String AUTHZ_MGR_LOOKUP = "java:comp/env/security/authorizationMgr";
    protected SecurityAdaptorFactory secAdapterfactory;

    public Set<QName> getHeaders() {
        return headers;
    }

    protected AuthenticationManager getAuthenticationManager() {
        if (this.secAdapterfactory == null) {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            this.secAdapterfactory = (SecurityAdaptorFactory)spiProvider.getSPI(SecurityAdaptorFactory.class);
        }
        return (AuthenticationManager)this.lookupJNDI(SEC_MGR_LOOKUP);
    }

    protected AuthorizationManager getAuthorizationManager() {
        if (this.secAdapterfactory == null) {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            this.secAdapterfactory = (SecurityAdaptorFactory)spiProvider.getSPI(SecurityAdaptorFactory.class);
        }
        return (AuthorizationManager)this.lookupJNDI(AUTHZ_MGR_LOOKUP);
    }

    protected Element getSecurityHeaderElement(Document document) {
        Element element = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        Util.addNamespace(element, "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        Util.addNamespace(element, "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Util.addNamespace(element, "ds", "http://www.w3.org/2000/09/xmldsig#");
        return element;
    }

    protected void trace(MessageContext msgContext) {
        if (logger.isTraceEnabled() && msgContext instanceof SOAPMessageContext) {
            SOAPMessageContext soapMessageContext = (SOAPMessageContext)msgContext;
            logger.trace("WSDL_PORT=" + soapMessageContext.get((Object)"javax.xml.ws.wsdl.port"));
            logger.trace("WSDL_OPERATION=" + soapMessageContext.get((Object)"javax.xml.ws.wsdl.operation"));
            logger.trace("WSDL_INTERFACE=" + soapMessageContext.get((Object)"javax.xml.ws.wsdl.interface"));
            logger.trace("WSDL_SERVICE=" + soapMessageContext.get((Object)"javax.xml.ws.wsdl.service"));
        }
    }

    protected String getUsername(Element nameID) {
        String username = nameID.getNodeValue();
        if (username == null) {
            NodeList childNodes = nameID.getChildNodes();
            int size = childNodes.getLength();
            for (int i = 0; i < size; ++i) {
                Node childNode = childNodes.item(i);
                if (childNode.getNodeType() != 3) continue;
                username = childNode.getNodeValue();
            }
        }
        return username;
    }

    protected Element getAssertionFromSubject() {
        Element assertion = null;
        Subject subject = SecurityActions.getAuthenticatedSubject();
        if (subject == null) {
            logger.trace("No authentication Subject found, cannot provide any user roles!");
            return assertion;
        }
        Set<Object> creds = subject.getPublicCredentials();
        if (creds != null) {
            for (Object cred : creds) {
                if (!(cred instanceof SamlCredential)) continue;
                SamlCredential samlCredential = (SamlCredential)cred;
                try {
                    assertion = samlCredential.getAssertionAsElement();
                }
                catch (ProcessingException e) {
                    logger.samlAssertionPasingFailed((Throwable)e);
                }
                break;
            }
        }
        return assertion;
    }

    private Object lookupJNDI(String str) {
        try {
            InitialContext context = new InitialContext();
            return context.lookup(str);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        HashSet<QName> set = new HashSet<QName>();
        set.add(Constants.WSSE_HEADER_QNAME);
        headers = Collections.unmodifiableSet(set);
    }
}

