/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.handler;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.xml.ws.handler.MessageContext;
import org.jboss.security.AuthenticationManager;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.picketlink.trust.jbossws.handler.AbstractPicketLinkTrustHandler;

public class WSAuthenticationHandler
extends AbstractPicketLinkTrustHandler {
    protected boolean handleInbound(MessageContext msgContext) {
        logger.trace("Handling Inbound Message");
        this.trace(msgContext);
        AuthenticationManager authenticationManager = this.getAuthenticationManager();
        SecurityAdaptor securityAdaptor = this.secAdapterfactory.newSecurityAdapter();
        Principal principal = securityAdaptor.getPrincipal();
        Object credential = securityAdaptor.getCredential();
        Subject subject = new Subject();
        if (!authenticationManager.isValid(principal, credential, subject)) {
            String msg = "PL00102: Processing Exception:Authentication failed, principal=" + principal;
            logger.error(msg);
            SecurityException e = new SecurityException(msg);
            throw new RuntimeException(e);
        }
        logger.trace("Successfully Authenticated:Principal = " + principal + "  ::subject = " + subject);
        securityAdaptor.pushSubjectContext(subject, principal, credential);
        return true;
    }
}

