/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.jaas;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.login.LoginException;
import javax.xml.ws.Binding;
import javax.xml.ws.Dispatch;
import javax.xml.ws.handler.Handler;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkPrincipal;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.identity.federation.core.wstrust.auth.STSIssuingLoginModule;
import org.picketlink.trust.jbossws.PicketLinkDispatch;
import org.picketlink.trust.jbossws.handler.BinaryTokenHandler;
import org.picketlink.trust.jbossws.handler.MapBasedTokenHandler;
import org.picketlink.trust.jbossws.handler.SAML2Handler;
import org.picketlink.trust.jbossws.jaas.SecurityActions;

public class JBWSTokenIssuingLoginModule
extends STSIssuingLoginModule {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String WSA_ISSUER = "wsaIssuer";
    public static final String WSP_APPIESTO = "wspAppliesTo";

    protected STSClientConfig.Builder createBuilder() {
        STSClientConfig.Builder builder = super.createBuilder();
        builder.wsaIssuer((String)this.options.get(WSA_ISSUER));
        builder.wspAppliesTo((String)this.options.get(WSP_APPIESTO));
        return builder;
    }

    protected STSClient createWSTrustClient(STSClientConfig config) {
        String binaryTokenKey = (String)this.options.get("map.token.key");
        if (binaryTokenKey == null) {
            binaryTokenKey = SecurityActions.getSystemProperty("map.token.key", "ClientID");
        }
        Object binaryToken = this.sharedState.get(binaryTokenKey);
        HashMap STSClientOptions = new HashMap(this.options);
        if (binaryToken != null) {
            STSClientOptions.put(binaryTokenKey, binaryToken);
        }
        return new JBWSTokenClient(config, STSClientOptions);
    }

    public boolean commit() throws LoginException {
        boolean result = super.commit();
        if (result) {
            SamlCredential samlCredential = null;
            Set<Object> creds = this.subject.getPublicCredentials();
            for (Object cred : creds) {
                if (!(cred instanceof SamlCredential)) continue;
                samlCredential = (SamlCredential)cred;
                break;
            }
            if (samlCredential == null) {
                throw logger.authSAMLCredentialNotAvailable();
            }
            PicketLinkPrincipal principal = new PicketLinkPrincipal("");
            if (super.isUseFirstPass()) {
                this.sharedState.put("javax.security.auth.login.name", principal);
                this.sharedState.put("javax.security.auth.login.password", samlCredential);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JBWSTokenClient
    extends STSClient {
        public JBWSTokenClient() {
        }

        public JBWSTokenClient(STSClientConfig config) {
            super(config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JBWSTokenClient(STSClientConfig config, Map<String, ? super Object> options) {
            boolean bool;
            super(config);
            Dispatch dispatch = super.getDispatch();
            String overrideDispatchStr = (String)options.get("overrideDispatch");
            if (StringUtil.isNotNull((String)overrideDispatchStr) && (bool = Boolean.valueOf(overrideDispatchStr).booleanValue())) {
                dispatch = new PicketLinkDispatch(dispatch, (String)options.get("endpointAddress"));
                String useWSSE = (String)options.get("useWSSE");
                if (StringUtil.isNotNull((String)useWSSE) && useWSSE.equalsIgnoreCase("true")) {
                    ((PicketLinkDispatch)dispatch).setUseWSSE(true);
                }
            }
            Binding binding = dispatch.getBinding();
            List handlers = binding.getHandlerChain();
            String handlerStr = (String)options.get("handlerChain");
            if (StringUtil.isNotNull((String)handlerStr)) {
                List tokens = StringUtil.tokenize((String)handlerStr);
                for (String token : tokens) {
                    if (token.equalsIgnoreCase("binary")) {
                        BinaryTokenHandler binaryTokenHandler = new BinaryTokenHandler();
                        handlers.add(binaryTokenHandler);
                        continue;
                    }
                    if (token.equalsIgnoreCase("saml2")) {
                        SAML2Handler samlHandler = new SAML2Handler();
                        handlers.add(samlHandler);
                        continue;
                    }
                    if (token.equalsIgnoreCase("map")) {
                        MapBasedTokenHandler mapBasedHandler = new MapBasedTokenHandler(options);
                        handlers.add(mapBasedHandler);
                        continue;
                    }
                    ClassLoader cl = SecurityActions.getClassLoader(((Object)((Object)this)).getClass());
                    try {
                        handlers.add((Handler)cl.loadClass(token).newInstance());
                    }
                    catch (Exception e) {
                        throw logger.authUnableToInstantiateHandler(token, (Throwable)e);
                    }
                }
            }
            binding.setHandlerChain(handlers);
            this.setDispatch(dispatch);
            String securityDomainForFactory = (String)options.get("securityDomainForFactory");
            if (StringUtil.isNotNull((String)securityDomainForFactory)) {
                logger.trace("We got security domain for domain ssl factory = " + securityDomainForFactory);
                logger.trace("Setting it on the system property org.jboss.security.ssl.domain.name");
                String sslFactoryName = "org.jboss.security.ssl.JaasSecurityDomainSocketFactory";
                SecurityActions.setSystemProperty("org.jboss.security.ssl.domain.name", securityDomainForFactory);
                dispatch.getRequestContext().put("org.jboss.ws.socketFactory", sslFactoryName);
                if (dispatch instanceof PicketLinkDispatch) {
                    ClassLoader cl = SecurityActions.getClassLoader(((Object)((Object)this)).getClass());
                    SSLSocketFactory socketFactory = null;
                    if (cl != null) {
                        try {
                            Class<?> clazz = cl.loadClass(sslFactoryName);
                            socketFactory = (SSLSocketFactory)clazz.newInstance();
                        }
                        catch (Exception e) {
                            cl = SecurityActions.getContextClassLoader();
                            try {
                                Class<?> clazz = cl.loadClass(sslFactoryName);
                                socketFactory = (SSLSocketFactory)clazz.newInstance();
                            }
                            catch (Exception e1) {
                                throw logger.jbossWSUnableToCreateSSLSocketFactory((Throwable)e1);
                            }
                        }
                        finally {
                            if (socketFactory == null) {
                                throw logger.jbossWSUnableToFindSSLSocketFactory();
                            }
                            ((PicketLinkDispatch)dispatch).setSSLSocketFactory(socketFactory);
                        }
                    } else {
                        logger.trace("Classloader is null. Unable to set the SSLSocketFactory on PicketLinkDispatch");
                    }
                }
            }
        }
    }
}

