/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.jaas;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Principal;
import java.security.acl.Group;
import java.util.List;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;

public class SAMLRoleLoginModule
extends AbstractServerLoginModule {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public boolean commit() throws LoginException {
        this.loginOk = true;
        return super.commit();
    }

    protected Principal getIdentity() {
        Object sharedName = this.sharedState.get("javax.security.auth.login.name");
        if (sharedName != null && sharedName instanceof String) {
            return new SimplePrincipal((String)sharedName);
        }
        Principal principal = (Principal)sharedName;
        if (principal != null) {
            return principal;
        }
        NameCallback nameCallback = new NameCallback("UserName:");
        try {
            this.callbackHandler.handle(new Callback[]{nameCallback});
            String userName = nameCallback.getName();
            if (StringUtil.isNotNull((String)userName)) {
                return new SimplePrincipal(userName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set<Principal> principals = this.subject.getPrincipals();
        for (Principal p : principals) {
            if (p instanceof Group) continue;
            return p;
        }
        throw logger.authUnableToGetIdentityFromSubject();
    }

    protected Group[] getRoleSets() throws LoginException {
        SamlCredential samlCredential = null;
        Set<Object> creds = this.subject.getPublicCredentials();
        for (Object cred : creds) {
            if (!(cred instanceof SamlCredential)) continue;
            samlCredential = (SamlCredential)cred;
            break;
        }
        if (samlCredential == null) {
            throw logger.authSAMLCredentialNotAvailable();
        }
        try {
            String assertionStr = samlCredential.getAssertionAsString();
            if (StringUtil.isNullOrEmpty((String)assertionStr)) {
                throw logger.authSAMLAssertionNullOrEmpty();
            }
            SAMLParser parser = new SAMLParser();
            AssertionType assertion = (AssertionType)parser.parse((InputStream)new ByteArrayInputStream(assertionStr.getBytes()));
            List roles = AssertionUtil.getRoles((AssertionType)assertion, null);
            SimpleGroup roleGroup = new SimpleGroup("Roles");
            for (String role : roles) {
                roleGroup.addMember((Principal)new SimplePrincipal(role));
            }
            return new Group[]{roleGroup};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

