/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.xml.ws.Dispatch;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.callback.ObjectCallback;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.exceptions.fed.WSTrustException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.bindings.jboss.auth.SAMLTokenFromHttpRequestAbstractLoginModule;
import org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkGroup;
import org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkPrincipal;
import org.picketlink.identity.federation.core.factories.JBossAuthCacheInvalidationFactory;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.identity.federation.core.wstrust.auth.AbstractSTSLoginModule;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SAML2STSCommonLoginModule
extends SAMLTokenFromHttpRequestAbstractLoginModule {
    protected String stsConfigurationFile;
    protected Principal principal;
    protected SamlCredential credential;
    protected AssertionType assertion;
    protected boolean enableCacheInvalidation = false;
    protected String securityDomain = null;
    protected boolean localValidation = false;
    protected String localValidationSecurityDomain;
    protected String roleKey = "Role";
    protected Map<String, Object> options = new HashMap<String, Object>();
    protected Map<String, Object> rawOptions = new HashMap<String, Object>();
    public static final String STS_CONFIG_FILE = "configFile";
    public static final String ENDPOINT_ADDRESS = "endpointAddress";
    public static final String PORT_NAME = "portName";
    public static final String SERVICE_NAME = "serviceName";
    public static final String USERNAME_KEY = "username";
    public static final String PASSWORD_KEY = "password";
    protected boolean localTestingOnly = false;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String localValidationStr;
        String roleKeyStr;
        super.initialize(subject, callbackHandler, sharedState, options);
        this.options.putAll(options);
        this.rawOptions.putAll(options);
        if (logger.isTraceEnabled()) {
            logger.trace(options.toString());
        }
        this.stsConfigurationFile = (String)this.options.remove(STS_CONFIG_FILE);
        String cacheInvalidation = (String)this.options.remove("cache.invalidation");
        if (cacheInvalidation != null && !cacheInvalidation.isEmpty()) {
            this.enableCacheInvalidation = Boolean.parseBoolean(cacheInvalidation);
            this.securityDomain = (String)this.options.remove("jboss.security.security_domain");
            if (this.securityDomain == null || this.securityDomain.isEmpty()) {
                throw logger.optionNotSet("jboss.security.security_domain");
            }
        }
        if (StringUtil.isNotNull((String)(roleKeyStr = (String)options.get("roleKey")))) {
            this.roleKey = roleKeyStr.trim();
        }
        if (StringUtil.isNotNull((String)(localValidationStr = (String)options.get("localValidation")))) {
            String localTestingOnlyStr;
            this.localValidation = Boolean.parseBoolean(localValidationStr);
            this.localValidationSecurityDomain = (String)options.get("localValidationSecurityDomain");
            if (this.localValidationSecurityDomain == null) {
                logger.error("PL00105: When using local validation 'localValidationSecurityDomain' must be specified.");
                throw logger.optionNotSet("localValidationSecurityDomain");
            }
            if (!this.localValidationSecurityDomain.startsWith("java:")) {
                this.localValidationSecurityDomain = "java:jboss/jaas//" + this.localValidationSecurityDomain;
            }
            if (StringUtil.isNotNull((String)(localTestingOnlyStr = (String)options.get("localTestingOnly")))) {
                this.localTestingOnly = Boolean.valueOf(localTestingOnlyStr);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean login() throws LoginException {
        if (super.login()) {
            sharedPrincipal = this.sharedState.get("javax.security.auth.login.name");
            if (sharedPrincipal instanceof Principal) {
                this.principal = (Principal)sharedPrincipal;
            } else {
                try {
                    this.principal = this.createIdentity(sharedPrincipal.toString());
                }
                catch (Exception e) {
                    throw SAML2STSCommonLoginModule.logger.authFailedToCreatePrincipal((Throwable)e);
                }
            }
            credential = this.sharedState.get("javax.security.auth.login.password");
            if (!(credential instanceof SamlCredential)) {
                throw SAML2STSCommonLoginModule.logger.authSharedCredentialIsNotSAMLCredential(credential.getClass().getName());
            }
            this.credential = (SamlCredential)credential;
            return true;
        }
        callback = new ObjectCallback(null);
        assertionElement = null;
        try {
            if (this.getSamlTokenHttpHeader() != null) {
                this.credential = this.getCredentialFromHttpRequest();
            } else {
                this.callbackHandler.handle(new Callback[]{callback});
                if (callback.getCredential() instanceof String) {
                    callback.setCredential((Object)new SamlCredential(DocumentUtil.getDocument((String)callback.getCredential().toString()).getDocumentElement()));
                }
                if (!(callback.getCredential() instanceof SamlCredential)) {
                    throw SAML2STSCommonLoginModule.logger.authSharedCredentialIsNotSAMLCredential(callback.getCredential().getClass().getName());
                }
                this.credential = (SamlCredential)callback.getCredential();
            }
            assertionElement = this.credential.getAssertionAsElement();
        }
        catch (Exception e) {
            throw SAML2STSCommonLoginModule.logger.authErrorHandlingCallback((Throwable)e);
        }
        if (this.localValidation) {
            SAML2STSCommonLoginModule.logger.trace("Local Validation is being Performed");
            try {
                isValid = this.localValidation(assertionElement);
                if (!isValid) ** GOTO lbl55
                SAML2STSCommonLoginModule.logger.trace("Local Validation passed.");
            }
            catch (Exception e) {
                le = new LoginException();
                le.initCause(e);
                throw le;
            }
        } else {
            SAML2STSCommonLoginModule.logger.trace("Local Validation is disabled. Verifying with STS");
            if (this.stsConfigurationFile == null) {
                throw SAML2STSCommonLoginModule.logger.authSTSConfigFileNotFound();
            }
            client = this.getSTSClient();
            try {
                isValid = client.validateToken(assertionElement);
                if (!isValid) {
                    throw SAML2STSCommonLoginModule.logger.authInvalidSAMLAssertionBySTS();
                }
            }
            catch (WSTrustException we) {
                throw SAML2STSCommonLoginModule.logger.authAssertionValidationError((Throwable)we);
            }
        }
lbl55:
        // 3 sources

        try {
            this.assertion = SAMLUtil.fromElement((Element)assertionElement);
            subject = this.assertion.getSubject();
            if (subject != null && (baseID = subject.getSubType().getBaseID()) instanceof NameIDType) {
                nameID = (NameIDType)baseID;
                this.principal = new PicketLinkPrincipal(nameID.getValue());
                if (this.enableCacheInvalidation) {
                    cacheExpiry = this.getCacheExpiry();
                    expiry = AssertionUtil.getExpiration((AssertionType)this.assertion);
                    if (expiry != null) {
                        expiryDate = expiry.toGregorianCalendar().getTime();
                        SAML2STSCommonLoginModule.logger.trace("Creating Cache Entry for JBoss at [" + new Date() + "] , with expiration set to SAML expiry = " + expiryDate);
                        cacheExpiry.register(this.securityDomain, expiryDate, this.principal);
                    } else {
                        SAML2STSCommonLoginModule.logger.samlAssertionWithoutExpiration(this.assertion.getID());
                    }
                }
            }
        }
        catch (Exception e) {
            throw SAML2STSCommonLoginModule.logger.authFailedToParseSAMLAssertion((Throwable)e);
        }
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", this.principal);
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
        this.loginOk = true;
        return true;
    }

    public boolean commit() throws LoginException {
        if (super.commit()) {
            boolean added = this.subject.getPublicCredentials().add(this.credential);
            if (added && logger.isTraceEnabled()) {
                logger.trace("Added Credential " + this.credential);
            }
            return true;
        }
        return false;
    }

    public boolean abort() throws LoginException {
        this.clearState();
        super.abort();
        return true;
    }

    public boolean logout() throws LoginException {
        this.clearState();
        super.logout();
        return true;
    }

    private void clearState() {
        AbstractSTSLoginModule.removeAllSamlCredentials((Subject)this.subject);
        this.credential = null;
    }

    protected Principal getIdentity() {
        return this.principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        if (this.assertion == null) {
            try {
                this.assertion = SAMLUtil.fromElement((Element)this.credential.getAssertionAsElement());
            }
            catch (Exception e) {
                throw logger.authFailedToParseSAMLAssertion((Throwable)e);
            }
        }
        if (logger.isTraceEnabled()) {
            try {
                logger.trace("Assertion from where roles will be sought = " + AssertionUtil.asString((AssertionType)this.assertion));
            }
            catch (ProcessingException ignore) {
                // empty catch block
            }
        }
        ArrayList roleKeys = new ArrayList();
        if (StringUtil.isNotNull((String)this.roleKey)) {
            roleKeys.addAll(StringUtil.tokenize((String)this.roleKey));
        }
        String groupName = "Roles";
        PicketLinkGroup rolesGroup = new PicketLinkGroup(groupName);
        List roles = AssertionUtil.getRoles((AssertionType)this.assertion, roleKeys);
        for (String role : roles) {
            rolesGroup.addMember((Principal)new SimplePrincipal(role));
        }
        return new Group[]{rolesGroup};
    }

    protected STSClient getSTSClient() {
        STSClientConfig.Builder builder = null;
        STSClient client = null;
        if (this.rawOptions.containsKey(STS_CONFIG_FILE)) {
            builder = new STSClientConfig.Builder(this.stsConfigurationFile);
            client = new STSClient(builder.build());
        } else {
            builder = new STSClientConfig.Builder();
            builder.endpointAddress((String)this.rawOptions.get(ENDPOINT_ADDRESS));
            builder.portName((String)this.rawOptions.get(PORT_NAME)).serviceName((String)this.rawOptions.get(SERVICE_NAME));
            builder.username((String)this.rawOptions.get(USERNAME_KEY)).password((String)this.rawOptions.get(PASSWORD_KEY));
            String passwordString = (String)this.rawOptions.get(PASSWORD_KEY);
            if (passwordString != null && passwordString.startsWith("MASK-")) {
                String salt = (String)this.rawOptions.get("salt");
                if (StringUtil.isNullOrEmpty((String)salt)) {
                    throw logger.optionNotSet("Salt");
                }
                String iCount = (String)this.rawOptions.get("iterationCount");
                if (StringUtil.isNullOrEmpty((String)iCount)) {
                    throw logger.optionNotSet("Iteration Count");
                }
                int iterationCount = Integer.parseInt(iCount);
                try {
                    builder.password(StringUtil.decode((String)passwordString, (String)salt, (int)iterationCount));
                }
                catch (Exception e) {
                    throw logger.unableToDecodePasswordError(passwordString);
                }
            }
            client = new STSClient(builder.build());
        }
        if (!this.options.isEmpty()) {
            Dispatch dispatch = client.getDispatch();
            for (Map.Entry<String, Object> entry : this.options.entrySet()) {
                dispatch.getRequestContext().put(entry.getKey(), entry.getValue());
            }
        }
        return client;
    }

    protected abstract boolean localValidation(Element var1) throws Exception;

    protected abstract JBossAuthCacheInvalidationFactory.TimeCacheExpiry getCacheExpiry() throws Exception;
}

