/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.login.LoginException;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.picketlink.common.util.StringUtil;

public class RegExUserNameLoginModule
extends UsernamePasswordLoginModule {
    private Principal identity;
    private char[] credential;

    public boolean login() throws LoginException {
        Object username = this.sharedState.get("javax.security.auth.login.name");
        if (username == null) {
            throw new LoginException("PB00019: Processing Failed:: No username");
        }
        if (username instanceof Principal) {
            this.identity = (Principal)username;
            String extractedUserName = this.extractUserName(this.identity.getName());
            try {
                this.identity = this.createIdentity(extractedUserName);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to create principal", (Throwable)e);
            }
        } else {
            String name = username.toString();
            name = this.extractUserName(name);
            try {
                this.identity = this.createIdentity(name);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to create principal", (Throwable)e);
                throw new LoginException("PB00019: Processing Failed:Failed to create principal: " + e.getMessage());
            }
        }
        Object password = this.sharedState.get("javax.security.auth.login.password");
        if (password instanceof char[]) {
            this.credential = (char[])password;
        } else if (password != null) {
            String tmp = password.toString();
            this.credential = tmp.toCharArray();
        }
        this.sharedState.put("javax.security.auth.login.name", this.identity);
        this.sharedState.put("javax.security.auth.login.password", this.credential);
        return true;
    }

    protected String getUsersPassword() throws LoginException {
        return null;
    }

    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }

    protected String extractUserName(String theName) {
        Pattern pattern;
        Matcher matcher;
        String regex = (String)this.options.get("regex");
        if (StringUtil.isNotNull((String)regex) && (matcher = (pattern = Pattern.compile(regex)).matcher(theName)).find()) {
            return matcher.group(1);
        }
        return theName;
    }
}

