/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.cache.IdentityObjectRelationshipNameSearchImpl;
import org.picketlink.idm.impl.cache.IdentityObjectRelationshipSearchImpl;
import org.picketlink.idm.impl.cache.IdentityObjectSearchImpl;
import org.picketlink.idm.impl.cache.JBossCacheAttributeStoreWrapper;
import org.picketlink.idm.impl.types.SimpleIdentityObjectRelationship;
import org.picketlink.idm.spi.cache.IdentityStoreCacheProvider;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.exception.OperationNotSupportedException;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectCredential;
import org.picketlink.idm.spi.model.IdentityObjectRelationship;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;
import org.picketlink.idm.spi.store.FeaturesMetaData;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheIdentityStoreWrapper
extends JBossCacheAttributeStoreWrapper
implements IdentityStore {
    private static Logger log = Logger.getLogger(JBossCacheIdentityStoreWrapper.class.getName());
    private final IdentityStore identityStore;

    public JBossCacheIdentityStoreWrapper(IdentityStore identityStore, IdentityStoreCacheProvider cacheSupport, String cacheScope) throws IdentityException {
        super(identityStore, cacheSupport, cacheScope);
        this.identityStore = identityStore;
        log.fine("------------------------------------------------------");
        log.fine("JBossCacheIdentityStoreWrapper created .....(IdentityStore: " + identityStore.getId() + "; cache scope: " + cacheScope + ")");
        log.fine("------------------------------------------------------");
    }

    @Override
    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
        this.identityStore.bootstrap(configurationContext);
    }

    @Override
    public FeaturesMetaData getSupportedFeatures() {
        return this.identityStore.getSupportedFeatures();
    }

    @Override
    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType) throws IdentityException {
        IdentityObject io = this.identityStore.createIdentityObject(invocationCtx, name, identityObjectType);
        if (io != null) {
            this.cacheSupport.invalidateIdentityObjectRelationshipNameSearches(this.getCacheNS(invocationCtx));
            this.cacheSupport.invalidateIdentityObjectRelationshipSearches(this.getCacheNS(invocationCtx));
            this.cacheSupport.invalidateIdentityObjectSearches(this.getCacheNS(invocationCtx));
            this.cacheSupport.invalidateIdentityObjectCount(this.getCacheNS(invocationCtx), identityObjectType.getName());
        }
        return io;
    }

    @Override
    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType, Map<String, String[]> attributes) throws IdentityException {
        IdentityObject io = this.identityStore.createIdentityObject(invocationCtx, name, identityObjectType, attributes);
        if (io != null) {
            this.cacheSupport.invalidateIdentityObjectRelationshipNameSearches(this.getCacheNS(invocationCtx));
            this.cacheSupport.invalidateIdentityObjectRelationshipSearches(this.getCacheNS(invocationCtx));
            this.cacheSupport.invalidateIdentityObjectSearches(this.getCacheNS(invocationCtx));
            this.cacheSupport.invalidateIdentityObjectCount(this.getCacheNS(invocationCtx), identityObjectType.getName());
        }
        return io;
    }

    @Override
    public void removeIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity) throws IdentityException {
        this.identityStore.removeIdentityObject(invocationCtx, identity);
        this.cacheSupport.invalidateIdentityObjectRelationshipNameSearches(this.getCacheNS(invocationCtx));
        this.cacheSupport.invalidateIdentityObjectRelationshipSearches(this.getCacheNS(invocationCtx));
        this.cacheSupport.invalidateIdentityObjectSearches(this.getCacheNS(invocationCtx));
        this.cacheSupport.invalidateIdentityObjectAttriubtes(this.getCacheNS(invocationCtx), identity);
        this.cacheSupport.invalidateIdentityObjectCount(this.getCacheNS(invocationCtx), identity.getIdentityType().getName());
    }

    @Override
    public int getIdentityObjectsCount(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType) throws IdentityException {
        int count = this.cacheSupport.getIdentityObjectCount(this.getCacheNS(invocationCtx), identityType.getName());
        if (count != -1) {
            return count;
        }
        count = this.identityStore.getIdentityObjectsCount(invocationCtx, identityType);
        this.cacheSupport.putIdentityObjectCount(this.getCacheNS(invocationCtx), identityType.getName(), count);
        return count;
    }

    @Override
    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String name, IdentityObjectType identityObjectType) throws IdentityException {
        Collection<IdentityObject> results;
        IdentityObjectSearchImpl search = new IdentityObjectSearchImpl();
        search.setName(name);
        if (identityObjectType != null) {
            search.setType(identityObjectType.getName());
        }
        if ((results = this.cacheSupport.getIdentityObjectSearch(this.getCacheNS(invocationContext), search)) != null && results.size() == 1) {
            return results.iterator().next();
        }
        IdentityObject io = this.identityStore.findIdentityObject(invocationContext, name, identityObjectType);
        if (io != null) {
            HashSet<IdentityObject> temp = new HashSet<IdentityObject>();
            temp.add(io);
            this.cacheSupport.putIdentityObjectSearch(this.getCacheNS(invocationContext), search, temp);
        }
        return io;
    }

    @Override
    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String id) throws IdentityException {
        IdentityObjectSearchImpl search = new IdentityObjectSearchImpl();
        search.setId(id);
        Collection<IdentityObject> results = this.cacheSupport.getIdentityObjectSearch(this.getCacheNS(invocationContext), search);
        if (results != null && results.size() == 1) {
            return results.iterator().next();
        }
        IdentityObject io = this.identityStore.findIdentityObject(invocationContext, id);
        if (io != null) {
            HashSet<IdentityObject> temp = new HashSet<IdentityObject>();
            temp.add(io);
            this.cacheSupport.putIdentityObjectSearch(this.getCacheNS(invocationContext), search, temp);
        }
        return io;
    }

    @Override
    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType, IdentityObjectSearchCriteria criteria) throws IdentityException {
        Collection<IdentityObject> results = this.identityStore.findIdentityObject(invocationCtx, identityType, criteria);
        return results;
    }

    @Override
    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        Collection<IdentityObject> results;
        IdentityObjectSearchImpl search = new IdentityObjectSearchImpl();
        search.setIdentityObjectSearchCriteria(criteria);
        search.setParent(parent);
        if (relationshipType != null) {
            search.setRelationshipType(relationshipType.getName());
        }
        if (identity != null) {
            search.setName(identity.getName());
            search.setType(identity.getIdentityType().getName());
        }
        if ((results = this.cacheSupport.getIdentityObjectSearch(this.getCacheNS(invocationCtx), search)) != null) {
            return results;
        }
        results = this.identityStore.findIdentityObject(invocationCtx, identity, relationshipType, parent, criteria);
        this.cacheSupport.putIdentityObjectSearch(this.getCacheNS(invocationCtx), search, results);
        return results;
    }

    @Override
    public IdentityObjectRelationship createRelationship(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName, boolean createNames) throws IdentityException {
        this.cacheSupport.invalidateIdentityObjectRelationshipNameSearches(this.getCacheNS(invocationCxt));
        this.cacheSupport.invalidateIdentityObjectRelationshipSearches(this.getCacheNS(invocationCxt));
        this.cacheSupport.invalidateIdentityObjectSearches(this.getCacheNS(invocationCxt));
        return this.identityStore.createRelationship(invocationCxt, fromIdentity, toIdentity, relationshipType, relationshipName, createNames);
    }

    @Override
    public void removeRelationship(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName) throws IdentityException {
        this.identityStore.removeRelationship(invocationCxt, fromIdentity, toIdentity, relationshipType, relationshipName);
        this.cacheSupport.invalidateIdentityObjectRelationshipNameSearches(this.getCacheNS(invocationCxt));
        this.cacheSupport.invalidateIdentityObjectRelationshipSearches(this.getCacheNS(invocationCxt));
        this.cacheSupport.invalidateIdentityObjectSearches(this.getCacheNS(invocationCxt));
        SimpleIdentityObjectRelationship relationship = new SimpleIdentityObjectRelationship(fromIdentity, toIdentity, relationshipName, relationshipType);
        this.cacheSupport.invalidateRelationshipProperties(this.getCacheNS(invocationCxt), relationship);
    }

    @Override
    public void removeRelationships(IdentityStoreInvocationContext invocationCtx, IdentityObject identity1, IdentityObject identity2, boolean named) throws IdentityException {
        this.identityStore.removeRelationships(invocationCtx, identity1, identity2, named);
        this.cacheSupport.invalidateIdentityObjectRelationshipNameSearches(this.getCacheNS(invocationCtx));
        this.cacheSupport.invalidateIdentityObjectRelationshipSearches(this.getCacheNS(invocationCtx));
        this.cacheSupport.invalidateIdentityObjectSearches(this.getCacheNS(invocationCtx));
        this.cacheSupport.invalidateRelationshipProperties(this.getCacheNS(invocationCtx));
    }

    @Override
    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        Set<IdentityObjectRelationship> results;
        IdentityObjectRelationshipSearchImpl search = new IdentityObjectRelationshipSearchImpl();
        if (fromIdentity != null) {
            search.setFromIOName(fromIdentity.getName());
            search.setFromIOType(fromIdentity.getIdentityType().getName());
        }
        if (toIdentity != null) {
            search.setToIOName(toIdentity.getName());
            search.setToIOType(toIdentity.getIdentityType().getName());
        }
        if (relationshipType != null) {
            search.setRelationshipType(relationshipType.getName());
        }
        if ((results = this.cacheSupport.getIdentityObjectRelationshipSearch(this.getCacheNS(invocationCxt), search)) != null) {
            return results;
        }
        results = this.identityStore.resolveRelationships(invocationCxt, fromIdentity, toIdentity, relationshipType);
        this.cacheSupport.putIdentityObjectRelationshipSearch(this.getCacheNS(invocationCxt), search, results);
        return results;
    }

    @Override
    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, boolean named, String name) throws IdentityException {
        IdentityObjectRelationshipSearchImpl search = new IdentityObjectRelationshipSearchImpl();
        if (identity != null) {
            search.setIoName(identity.getName());
            search.setIoType(identity.getIdentityType().getName());
        }
        if (relationshipType != null) {
            search.setRelationshipType(relationshipType.getName());
        }
        search.setParent(parent);
        search.setNamed(named);
        search.setName(name);
        Set<IdentityObjectRelationship> results = this.cacheSupport.getIdentityObjectRelationshipSearch(this.getCacheNS(invocationCtx), search);
        if (results != null) {
            return results;
        }
        results = this.identityStore.resolveRelationships(invocationCtx, identity, relationshipType, parent, named, name);
        this.cacheSupport.putIdentityObjectRelationshipSearch(this.getCacheNS(invocationCtx), search, results);
        return results;
    }

    @Override
    public String createRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        this.cacheSupport.invalidateIdentityObjectRelationshipNameSearches(this.getCacheNS(ctx));
        this.cacheSupport.invalidateIdentityObjectRelationshipSearches(this.getCacheNS(ctx));
        this.cacheSupport.invalidateIdentityObjectSearches(this.getCacheNS(ctx));
        return this.identityStore.createRelationshipName(ctx, name);
    }

    @Override
    public String removeRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        this.cacheSupport.invalidateIdentityObjectRelationshipNameSearches(this.getCacheNS(ctx));
        this.cacheSupport.invalidateIdentityObjectRelationshipSearches(this.getCacheNS(ctx));
        this.cacheSupport.invalidateIdentityObjectSearches(this.getCacheNS(ctx));
        this.cacheSupport.invalidateRelationshipNameProperties(this.getCacheNS(ctx), name);
        return this.identityStore.removeRelationshipName(ctx, name);
    }

    @Override
    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        IdentityObjectRelationshipNameSearchImpl search = new IdentityObjectRelationshipNameSearchImpl();
        search.setIdentityObjectSearchCriteria(criteria);
        Set<String> results = this.cacheSupport.getIdentityObjectRelationshipNameSearch(this.getCacheNS(ctx), search);
        if (results != null) {
            return results;
        }
        results = this.identityStore.getRelationshipNames(ctx, criteria);
        this.cacheSupport.putIdentityObjectRelationshipNameSearch(this.getCacheNS(ctx), search, results);
        return results;
    }

    @Override
    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        IdentityObjectRelationshipNameSearchImpl search = new IdentityObjectRelationshipNameSearchImpl();
        if (identity != null) {
            search.setIoName(identity.getName());
            search.setIoType(identity.getIdentityType().getName());
        }
        search.setIdentityObjectSearchCriteria(criteria);
        Set<String> results = this.cacheSupport.getIdentityObjectRelationshipNameSearch(this.getCacheNS(ctx), search);
        if (results != null) {
            return results;
        }
        results = this.identityStore.getRelationshipNames(ctx, identity, criteria);
        this.cacheSupport.putIdentityObjectRelationshipNameSearch(this.getCacheNS(ctx), search, results);
        return results;
    }

    @Override
    public Map<String, String> getRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        Map<String, String> properties = this.cacheSupport.getProperties(this.getCacheNS(ctx), name);
        if (properties != null) {
            return properties;
        }
        properties = this.identityStore.getRelationshipNameProperties(ctx, name);
        this.cacheSupport.putProperties(this.getCacheNS(ctx), name, properties);
        return properties;
    }

    @Override
    public void setRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        this.identityStore.setRelationshipNameProperties(ctx, name, properties);
        this.cacheSupport.invalidateRelationshipNameProperties(this.getCacheNS(ctx), name);
        this.cacheSupport.putProperties(this.getCacheNS(ctx), name, this.getRelationshipNameProperties(ctx, name));
    }

    @Override
    public void removeRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        this.identityStore.removeRelationshipNameProperties(ctx, name, properties);
        this.cacheSupport.invalidateRelationshipNameProperties(this.getCacheNS(ctx), name);
        this.cacheSupport.putProperties(this.getCacheNS(ctx), name, this.getRelationshipNameProperties(ctx, name));
    }

    @Override
    public Map<String, String> getRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException, OperationNotSupportedException {
        Map<String, String> properties = this.cacheSupport.getProperties(this.getCacheNS(ctx), relationship);
        if (properties != null) {
            return properties;
        }
        properties = this.identityStore.getRelationshipProperties(ctx, relationship);
        this.cacheSupport.putProperties(this.getCacheNS(ctx), relationship, properties);
        return properties;
    }

    @Override
    public void setRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        this.identityStore.setRelationshipProperties(ctx, relationship, properties);
        this.cacheSupport.invalidateRelationshipProperties(this.getCacheNS(ctx), relationship);
        this.cacheSupport.putProperties(this.getCacheNS(ctx), relationship, this.getRelationshipProperties(ctx, relationship));
    }

    @Override
    public void removeRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        this.identityStore.removeRelationshipProperties(ctx, relationship, properties);
        this.cacheSupport.invalidateRelationshipProperties(this.getCacheNS(ctx), relationship);
        this.cacheSupport.putProperties(this.getCacheNS(ctx), relationship, this.getRelationshipProperties(ctx, relationship));
    }

    @Override
    public boolean validateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        return this.identityStore.validateCredential(ctx, identityObject, credential);
    }

    @Override
    public void updateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        this.identityStore.updateCredential(ctx, identityObject, credential);
    }

    @Override
    public String toString() {
        return "JBossCacheIdentityStoreWrapper (IdentityStore=" + this.identityStore.getId() + ")";
    }
}

