/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.cache;

import java.util.Collection;
import java.util.HashSet;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.cache.RelationshipSearch;
import org.picketlink.idm.impl.api.model.GroupKey;
import org.picketlink.idm.impl.api.model.SimpleGroup;
import org.picketlink.idm.impl.api.model.SimpleUser;
import org.picketlink.idm.impl.cache.AbstractSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipSearchImpl
extends AbstractSearch
implements RelationshipSearch {
    private Collection<IdentityType> parents = new HashSet<IdentityType>();
    private Collection<IdentityType> members = new HashSet<IdentityType>();

    public Collection<IdentityType> getParents() {
        return this.parents;
    }

    public Collection<IdentityType> getMembers() {
        return this.members;
    }

    public void setParents(Collection<IdentityType> parents) {
        this.parents = parents;
    }

    public void setMembers(Collection<IdentityType> members) {
        this.members = members;
    }

    public void addParent(IdentityType it) {
        this.parents.add(it);
    }

    public void addMember(IdentityType it) {
        this.members.add(it);
    }

    public void addParent(String id) {
        if (GroupKey.validateKey(id)) {
            this.parents.add(new SimpleGroup(new GroupKey(id)));
            return;
        }
        this.parents.add(new SimpleUser(id));
    }

    public void addMember(String id) {
        if (GroupKey.validateKey(id)) {
            this.members.add(new SimpleGroup(new GroupKey(id)));
            return;
        }
        this.members.add(new SimpleUser(id));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationshipSearchImpl that = (RelationshipSearchImpl)o;
        if (this.members != null ? !((Object)this.members).equals(that.members) : that.members != null) {
            return false;
        }
        return !(this.parents != null ? !((Object)this.parents).equals(that.parents) : that.parents != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.parents != null ? ((Object)this.parents).hashCode() : 0);
        result = 31 * result + (this.members != null ? ((Object)this.members).hashCode() : 0);
        return result;
    }
}

