/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.integration.jboss5;

import javax.transaction.TransactionManager;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.picketlink.idm.integration.jboss5.IDMMetadata;
import org.picketlink.idm.integration.jboss5.IDMService;
import org.picketlink.idm.integration.jboss5.jaxb2.InitializerType;
import org.picketlink.idm.integration.jboss5.jaxb2.PicketlinkIDMDeployerType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDMDeployer
extends AbstractSimpleVFSRealDeployer<IDMMetadata> {
    private TransactionManager transactionManager;
    private IDMService service;

    public IDMDeployer() {
        super(IDMMetadata.class);
    }

    public void deploy(VFSDeploymentUnit deploymentUnit, IDMMetadata metadata) throws DeploymentException {
        PicketlinkIDMDeployerType config = metadata.getDeploperType();
        this.service = new IDMService(config.getIdmConfigFile());
        if (this.transactionManager != null) {
            this.service.setTransactionManager(this.transactionManager);
        }
        if (config.getJNDIName() != null) {
            this.service.setIdmSessionFactoryJNDI(config.getJNDIName());
        }
        if (config.getHibernateDeployer() != null) {
            this.service.setHibernateConfigLocation(config.getHibernateDeployer().getHibernateConfiguration());
            this.service.setHibernateSessionFactoryJNDIName(config.getHibernateDeployer().getHibernateSessionFactoryJNDIName());
            this.service.setHibernateSessionFactoryRegistryName(config.getHibernateDeployer().getHibernateSessionFactoryRegistryName());
        }
        if (config.getInitializers() != null) {
            InitializerType initializers = config.getInitializers();
            if (initializers.getDatasource() != null) {
                this.service.setDatasource(initializers.getDatasource());
            }
            if (initializers.getSqlInitializer() != null) {
                this.service.setSQLScript(initializers.getSqlInitializer().getSqlFile());
                this.service.setExitSQL(initializers.getSqlInitializer().getExitSQL());
            }
            if (initializers.getHibernateInitializer() != null) {
                this.service.setDoChecking(initializers.getHibernateInitializer().isDoChecking());
            }
        }
        try {
            this.service.start();
        }
        catch (Exception e) {
            throw new DeploymentException("error in starting the service", (Throwable)e);
        }
    }

    public void undeploy(VFSDeploymentUnit deploymentUnit, IDMMetadata metadata) {
        this.service.destroy();
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

