/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.impl.configuration.IdentitySessionConfigurationContext;
import org.picketlink.idm.impl.helper.Tools;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;

public class IdentitySessionFactoryImpl
implements IdentitySessionFactory,
Serializable {
    private static final long serialVersionUID = 3806145082462607359L;
    private final Map<String, IdentitySession> realmMap = new HashMap<String, IdentitySession>();
    private final Map<String, IdentitySessionConfigurationContext> sessionContextMap;
    private final IdentityConfigurationMetaData configMD;

    public IdentitySessionFactoryImpl(IdentityConfigurationMetaData configMD, Map<String, IdentitySessionConfigurationContext> sessionContextMap) {
        this.sessionContextMap = sessionContextMap;
        this.configMD = configMD;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public IdentitySession createIdentitySession(String realmName) throws IdentityException {
        return this.createIdentitySession(realmName, null);
    }

    @Override
    public IdentitySession createIdentitySession(String realmName, Map<String, Object> sessionOptions) throws IdentityException {
        String defaultTemplate;
        IdentitySessionConfigurationContext sessionConfigCtx = this.sessionContextMap.get(realmName);
        if (sessionConfigCtx == null) {
            for (String ctx : this.sessionContextMap.keySet()) {
                String isTemplate;
                if (!realmName.startsWith(ctx) || (isTemplate = Tools.getOptionSingleValue("template", this.sessionContextMap.get(ctx).getRealmOptions())) == null || !isTemplate.equalsIgnoreCase("true")) continue;
                sessionConfigCtx = this.sessionContextMap.get(ctx);
                break;
            }
        }
        if (sessionConfigCtx == null && (defaultTemplate = Tools.getOptionSingleValue("defaultTemplate", this.configMD.getOptions())) != null && this.sessionContextMap.containsKey(defaultTemplate)) {
            sessionConfigCtx = this.sessionContextMap.get(defaultTemplate);
        }
        if (sessionConfigCtx == null) {
            throw new IdentityException("Cannot find configuration realm with a given name or any matching template: " + realmName);
        }
        IdentitySessionImpl newSession = new IdentitySessionImpl(realmName, sessionConfigCtx.getRepository(), sessionConfigCtx.getTypeMapper(), sessionConfigCtx.getApiCacheProvider(), sessionConfigCtx.getCredentialEncoder(), sessionConfigCtx.getIdentityConfigurationContext(), sessionConfigCtx.getRealmOptions(), sessionOptions);
        this.realmMap.put(realmName, newSession);
        return newSession;
    }

    @Override
    public IdentitySession getCurrentIdentitySession(String realmName) throws IdentityException {
        if (this.realmMap.containsKey(realmName)) {
            return this.realmMap.get(realmName);
        }
        return this.createIdentitySession(realmName);
    }
}

