/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.Identity;
import org.picketlink.authentication.web.BasicAuthenticationScheme;
import org.picketlink.authentication.web.ClientCertAuthenticationScheme;
import org.picketlink.authentication.web.DigestAuthenticationScheme;
import org.picketlink.authentication.web.FormAuthenticationScheme;
import org.picketlink.authentication.web.HTTPAuthenticationScheme;
import org.picketlink.common.util.StringUtil;
import org.picketlink.credential.DefaultLoginCredentials;

@ApplicationScoped
public class AuthenticationFilter
implements Filter {
    public static final String AUTH_TYPE_INIT_PARAM = "authType";
    public static final String UNPROTECTED_METHODS_INIT_PARAM = "unprotectedMethods";
    public static final String FORCE_REAUTHENTICATION_INIT_PARAM = "forceReAuthentication";
    private final Map<AuthType, Class<? extends HTTPAuthenticationScheme>> authenticationSchemes = new HashMap<AuthType, Class<? extends HTTPAuthenticationScheme>>();
    private final Set<String> unprotectedMethods;
    private boolean forceReAuthentication;
    @Inject
    private Instance<Identity> identityInstance;
    @Inject
    private Instance<DefaultLoginCredentials> credentialsInstance;
    private HTTPAuthenticationScheme authenticationScheme;

    public AuthenticationFilter() {
        this.authenticationSchemes.put(AuthType.DIGEST, DigestAuthenticationScheme.class);
        this.authenticationSchemes.put(AuthType.BASIC, BasicAuthenticationScheme.class);
        this.authenticationSchemes.put(AuthType.FORM, FormAuthenticationScheme.class);
        this.authenticationSchemes.put(AuthType.CLIENT_CERT, ClientCertAuthenticationScheme.class);
        this.unprotectedMethods = new HashSet<String>();
    }

    public void init(FilterConfig config) throws ServletException {
        String forceReAuthentication;
        this.initAuthenticationScheme(config);
        String unprotectedMethodsInitParam = config.getInitParameter(UNPROTECTED_METHODS_INIT_PARAM);
        if (unprotectedMethodsInitParam != null) {
            if (unprotectedMethodsInitParam.contains(",")) {
                for (String method : unprotectedMethodsInitParam.split(",")) {
                    this.unprotectedMethods.add(method.trim().toUpperCase());
                }
            } else {
                this.unprotectedMethods.add(unprotectedMethodsInitParam.trim().toUpperCase());
            }
        }
        if (StringUtil.isNullOrEmpty((String)(forceReAuthentication = config.getInitParameter(FORCE_REAUTHENTICATION_INIT_PARAM)))) {
            forceReAuthentication = "false";
        }
        this.forceReAuthentication = Boolean.valueOf(forceReAuthentication);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (!HttpServletRequest.class.isInstance(servletRequest)) {
            throw new ServletException("This filter can only process HttpServletRequest requests.");
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        Identity identity = this.getIdentity();
        DefaultLoginCredentials creds = this.extractCredentials(request);
        Object credential = creds.getCredential();
        if (credential != null && this.forceReAuthentication) {
            identity.logout();
            creds.setCredential(credential);
        }
        if (this.isProtected(request) && !identity.isLoggedIn()) {
            request.getSession();
            if (credential != null) {
                identity.login();
            }
            if (identity.isLoggedIn()) {
                if (this.authenticationScheme.postAuthentication(request, response)) {
                    chain.doFilter(servletRequest, servletResponse);
                }
            } else {
                this.authenticationScheme.challengeClient(request, response);
            }
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }

    private void initAuthenticationScheme(FilterConfig config) {
        AuthType authType;
        String authTypeName = config.getInitParameter(AUTH_TYPE_INIT_PARAM);
        if (authTypeName == null) {
            throw new IllegalArgumentException("Null authentication type provided.");
        }
        try {
            authType = AuthType.valueOf(authTypeName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unsupported authentication type. Possible values are: [" + AuthType.values() + ".", e);
        }
        Class<? extends HTTPAuthenticationScheme> authenticationScheme = this.authenticationSchemes.get((Object)authType);
        if (authenticationScheme == null) {
            throw new IllegalArgumentException("Authentication type of [" + (Object)((Object)authType) + "] does not match a HTTPAuthenticationScheme type.");
        }
        try {
            this.authenticationScheme = authenticationScheme.getConstructor(FilterConfig.class).newInstance(config);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create authentication scheme instance [" + authenticationScheme + "].", e);
        }
    }

    private DefaultLoginCredentials extractCredentials(HttpServletRequest request) {
        DefaultLoginCredentials creds = this.getCredentials();
        this.authenticationScheme.extractCredential(request, creds);
        return creds;
    }

    private DefaultLoginCredentials getCredentials() {
        if (this.credentialsInstance.isUnsatisfied()) {
            throw new IllegalStateException("DefaultLoginCredentials not found - please ensure that the DefaultLoginCredentials component is created on startup.");
        }
        if (this.credentialsInstance.isAmbiguous()) {
            throw new IllegalStateException("DefaultLoginCredentials is ambiguous. Make sure you have a single @RequestScoped instance.");
        }
        try {
            return (DefaultLoginCredentials)((Object)this.credentialsInstance.get());
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not retrieve credentials.", e);
        }
    }

    private Identity getIdentity() throws ServletException {
        if (this.identityInstance.isUnsatisfied()) {
            throw new IllegalStateException("Identity not found.");
        }
        if (this.identityInstance.isAmbiguous()) {
            throw new IllegalStateException("Identity is ambiguous.");
        }
        try {
            return (Identity)this.identityInstance.get();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not retrieve Identity.", e);
        }
    }

    private boolean isProtected(HttpServletRequest request) {
        return !this.unprotectedMethods.contains(request.getMethod().toUpperCase());
    }

    public static enum AuthType {
        BASIC,
        DIGEST,
        FORM,
        CLIENT_CERT;

    }
}

