/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.web;

import java.io.IOException;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.picketlink.authentication.web.HTTPAuthenticationScheme;
import org.picketlink.authentication.web.support.RequestCache;
import org.picketlink.authentication.web.support.SavedRequest;
import org.picketlink.credential.DefaultLoginCredentials;

public class FormAuthenticationScheme
implements HTTPAuthenticationScheme {
    public static final String FORM_LOGIN_PAGE_INIT_PARAM = "form-login-page";
    public static final String FORM_ERROR_PAGE_INIT_PARAM = "form-error-page";
    private RequestCache requestCache = new RequestCache();
    private final String formLoginPage;
    private final String formErrorPage;
    public static final String J_SECURITY_CHECK = "j_security_check";
    public static final String J_USERNAME = "j_username";
    public static final String J_PASSWORD = "j_password";
    public static final String SAVED_REQUEST = "SAVED_REQUEST";
    public static final String STATE = "STATE";

    public FormAuthenticationScheme(FilterConfig config) {
        String formLoginPage = config.getInitParameter(FORM_LOGIN_PAGE_INIT_PARAM);
        if (formLoginPage == null) {
            formLoginPage = "/login.jsp";
        }
        this.formLoginPage = formLoginPage;
        String formErrorPage = config.getInitParameter(FORM_ERROR_PAGE_INIT_PARAM);
        if (formErrorPage == null) {
            formErrorPage = "/loginError.jsp";
        }
        this.formErrorPage = formErrorPage;
    }

    @Override
    public void extractCredential(HttpServletRequest request, DefaultLoginCredentials creds) {
        if (this.isFormSubmitted(request)) {
            creds.setUserId(request.getParameter(J_USERNAME));
            creds.setPassword(request.getParameter(J_PASSWORD));
        }
    }

    @Override
    public void challengeClient(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        String sessionState = (String)session.getAttribute(STATE);
        if (sessionState == null || STATES.BEFORE_LOGIN.toString().equals(sessionState)) {
            this.requestCache.saveRequest(request);
            this.forwardToLoginPage(request, response);
            session.setAttribute(STATE, (Object)STATES.SHOW_LOGIN_PAGE.toString());
        }
    }

    @Override
    public boolean postAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        String state = (String)session.getAttribute(STATE);
        if (state != null && STATES.SHOW_LOGIN_PAGE.toString().equals(state)) {
            this.requestCache.removeAndStoreSavedRequestInSession(request);
            SavedRequest savedRequest = (SavedRequest)session.getAttribute(SAVED_REQUEST);
            String requestedURI = savedRequest.getRequestURI();
            session.setAttribute(STATE, (Object)STATES.AFTER_LOGIN.toString());
            response.sendRedirect(requestedURI);
        }
        return false;
    }

    private void forwardToLoginPage(HttpServletRequest request, HttpServletResponse response) {
        RequestDispatcher rd = request.getRequestDispatcher(this.formLoginPage);
        try {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void forwardToErrorPage(HttpServletRequest request, HttpServletResponse response) {
        RequestDispatcher rd = request.getRequestDispatcher(this.formErrorPage);
        try {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isFormSubmitted(HttpServletRequest request) {
        return request.getRequestURI().contains(J_SECURITY_CHECK);
    }

    private static enum STATES {
        BEFORE_LOGIN,
        SHOW_LOGIN_PAGE,
        AFTER_LOGIN;

    }
}

