/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.web.support;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class SavedRequest {
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String[]> parameters = new HashMap<String, String[]>();
    private String method;
    private String queryString;
    private String requestURI;
    private String scheme;
    private String contextPath;

    public SavedRequest(HttpServletRequest request) {
        this.copyCookies(request);
        this.copyHeaders(request);
        this.copyParameters(request);
        this.method = request.getMethod();
        this.queryString = request.getQueryString();
        this.requestURI = request.getRequestURI();
        this.scheme = request.getScheme();
        this.contextPath = request.getContextPath();
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    private void copyParameters(HttpServletRequest request) {
        Set parametersEntries = request.getParameterMap().entrySet();
        for (Map.Entry parameter : parametersEntries) {
            this.getParameters().put((String)parameter.getKey(), (String[])parameter.getValue());
        }
    }

    private void copyHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            this.getHeaders().put(headerName, headerValue);
        }
    }

    private void copyCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            this.getCookies().add(cookie);
        }
    }
}

