/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.picketlink.Identity;
import org.picketlink.annotations.StatelessIdentity;

public class StatelessIdentityExtension
implements Extension {
    private final boolean enableStatelessIdentity = this.isStatelessIdentityDefined();

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat, BeanManager beanManager) {
        AnnotatedType annotatedType;
        Class javaClass;
        if (this.enableStatelessIdentity && !Identity.class.equals((Object)(javaClass = (annotatedType = pat.getAnnotatedType()).getJavaClass())) && Identity.class.isAssignableFrom(javaClass)) {
            if (!javaClass.isAnnotationPresent(StatelessIdentity.class)) {
                pat.veto();
            } else {
                pat.setAnnotatedType(this.wrapStatalessIdentityBean(beanManager, annotatedType));
            }
        }
    }

    private <T> AnnotatedType<T> wrapStatalessIdentityBean(final BeanManager beanManager, final AnnotatedType<T> annotatedType) {
        return new AnnotatedType<T>(){
            public Set<Annotation> annotations;

            public Class<T> getJavaClass() {
                return annotatedType.getJavaClass();
            }

            public Set<AnnotatedConstructor<T>> getConstructors() {
                return annotatedType.getConstructors();
            }

            public Set<AnnotatedMethod<? super T>> getMethods() {
                return annotatedType.getMethods();
            }

            public Set<AnnotatedField<? super T>> getFields() {
                return annotatedType.getFields();
            }

            public Type getBaseType() {
                return annotatedType.getBaseType();
            }

            public Set<Type> getTypeClosure() {
                return annotatedType.getTypeClosure();
            }

            public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                for (Annotation annotation : this.getAnnotations()) {
                    if (!annotation.annotationType().equals(annotatedType)) continue;
                    return (T)annotation;
                }
                return null;
            }

            public Set<Annotation> getAnnotations() {
                if (this.annotations == null) {
                    HashSet annotations = new HashSet(beanManager.getStereotypeDefinition(StatelessIdentity.class));
                    annotations.addAll(annotatedType.getAnnotations());
                    for (Annotation annotation : new HashSet(annotations)) {
                        if (!annotation.annotationType().equals(StatelessIdentity.class) && !annotation.annotationType().equals(Stereotype.class) && !annotation.annotationType().equals(Alternative.class)) continue;
                        annotations.remove(annotation);
                    }
                    this.annotations = Collections.unmodifiableSet(annotations);
                }
                return this.annotations;
            }

            public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                for (Annotation annotation : this.getAnnotations()) {
                    if (!annotation.annotationType().equals(annotationType)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private boolean isStatelessIdentityDefined() {
        BufferedReader reader = null;
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = tccl.getResources(".");
            while (true) {
                String line;
                if (!resources.hasMoreElements()) break;
                URL url = resources.nextElement();
                String resourcePath = url.toString();
                if (!resourcePath.endsWith("WEB-INF/classes") && !resourcePath.endsWith("WEB-INF/classes/")) continue;
                InputStream beansXmlAsStream = this.getInputStream(new URL(resourcePath + "/../beans.xml"));
                if (beansXmlAsStream == null) {
                    beansXmlAsStream = this.getInputStream(new URL(resourcePath + "/META-INF/beans.xml"));
                }
                if (beansXmlAsStream == null) continue;
                reader = new BufferedReader(new InputStreamReader(beansXmlAsStream));
                while ((line = reader.readLine()) != null) {
                    if (!line.contains(StatelessIdentity.class.getName())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read beans.xml", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    private InputStream getInputStream(URL url) throws IOException {
        try {
            return new URL(url.toString()).openStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }
}

