/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.picketlink.config.http;

import java.io.Serializable;
import java.util.Map;

import static java.util.Collections.unmodifiableMap;

/**
 * @author Pedro Igor
 */
public class InboundHeaderConfiguration implements Serializable {

    private static final long serialVersionUID = 2372079491163757956L;

    public static final String X_REQUESTED_WITH_AJAX = "XMLHttpRequest";
    public static final String X_REQUESTED_WITH_HEADER_NAME = "X-Requested-With";

    private final Map<String, String[]> headers;
    private final PathConfiguration pathConfiguration;

    public InboundHeaderConfiguration(PathConfiguration pathConfiguration, Map<String, String[]> headers) {
        this.pathConfiguration = pathConfiguration;
        this.headers = headers;
    }

    public Map<String, String[]> getHeaders() {
        return unmodifiableMap(this.headers);
    }
}
