/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.http;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.config.http.AuthenticationConfiguration;
import org.picketlink.config.http.AuthorizationConfiguration;
import org.picketlink.config.http.CORSConfiguration;
import org.picketlink.config.http.HttpSecurityConfiguration;
import org.picketlink.config.http.HttpSecurityConfigurationException;
import org.picketlink.config.http.InboundHeaderConfiguration;
import org.picketlink.config.http.LogoutConfiguration;
import org.picketlink.config.http.OutboundRedirectConfiguration;
import org.picketlink.http.HttpMethod;
import org.picketlink.http.authorization.PathAuthorizer;

public class PathConfiguration
implements Serializable {
    private static final long serialVersionUID = 6185471280258386932L;
    public static final String URI_ALL = "/*";
    public static final String DEFAULT_GROUP_NAME = "Default";
    private final Boolean secured;
    private final List<OutboundRedirectConfiguration> redirects;
    private String groupName = "Default";
    private final String uri;
    private HttpSecurityConfiguration securityConfiguration;
    private LogoutConfiguration logoutConfiguration;
    private AuthenticationConfiguration authenticationConfiguration;
    private AuthorizationConfiguration authorizationConfiguration;
    private CORSConfiguration corsConfiguration;
    private InboundHeaderConfiguration inboundHeaderConfiguration;
    private Set<HttpMethod> methods;

    public PathConfiguration(String groupName, String uri, Boolean secured, Set<HttpMethod> methods, List<OutboundRedirectConfiguration> redirects) {
        if (groupName == null && uri == null) {
            throw new HttpSecurityConfigurationException("You must provide a group name or uri. Or even both.");
        }
        this.groupName = groupName;
        this.uri = uri;
        this.secured = secured;
        this.methods = methods != null && !methods.isEmpty() ? methods : new HashSet<HttpMethod>(Arrays.asList(HttpMethod.values()));
        if (redirects == null) {
            redirects = Collections.emptyList();
        }
        this.redirects = redirects;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isSecured() {
        if (this.secured == null) {
            if (this.hasGroup()) {
                PathConfiguration groupConfiguration = this.getGroupConfiguration();
                return groupConfiguration.isSecured();
            }
            return true;
        }
        return this.secured;
    }

    public boolean isGroup() {
        return this.groupName != null && !this.isDefaultGroup() && this.uri == null;
    }

    public boolean isUri() {
        return !this.isGroup();
    }

    public boolean isDefaultGroup() {
        return DEFAULT_GROUP_NAME.equals(this.groupName);
    }

    public HttpSecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    protected void setSecurityConfiguration(HttpSecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    private PathConfiguration getGroupConfiguration() {
        Map<String, PathConfiguration> groups = this.getSecurityConfiguration().getGroups();
        return groups.get(this.getGroupName());
    }

    private boolean hasGroup() {
        return this.isUri() && this.getGroupName() != null && !this.isDefaultGroup();
    }

    public AuthenticationConfiguration getAuthenticationConfiguration() {
        PathConfiguration pathConfiguration = this;
        if (pathConfiguration.isUri() && pathConfiguration.getGroupName() != null && !pathConfiguration.isDefaultGroup()) {
            Map<String, PathConfiguration> groups = pathConfiguration.getSecurityConfiguration().getGroups();
            PathConfiguration groupConfiguration = groups.get(pathConfiguration.getGroupName());
            AuthenticationConfiguration actualConfig = new AuthenticationConfiguration(this);
            if (this.authenticationConfiguration != null) {
                if (this.authenticationConfiguration.getAuthenticationSchemeConfiguration() == null) {
                    AuthenticationConfiguration groupAuthcConfig = groupConfiguration.getAuthenticationConfiguration();
                    actualConfig.setAuthenticationSchemeConfiguration(groupAuthcConfig.getAuthenticationSchemeConfiguration());
                    return actualConfig;
                }
            } else if (groupConfiguration != null) {
                return groupConfiguration.getAuthenticationConfiguration();
            }
        }
        return this.authenticationConfiguration;
    }

    protected void setAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = authenticationConfiguration;
    }

    public AuthorizationConfiguration getAuthorizationConfiguration() {
        PathConfiguration pathConfiguration = this;
        if (pathConfiguration.isUri() && pathConfiguration.getGroupName() != null && !pathConfiguration.isDefaultGroup()) {
            Map<String, PathConfiguration> groups = pathConfiguration.getSecurityConfiguration().getGroups();
            PathConfiguration groupConfiguration = groups.get(pathConfiguration.getGroupName());
            AuthorizationConfiguration groupAuthz = groupConfiguration.getAuthorizationConfiguration();
            if (this.authorizationConfiguration != null && groupAuthz != null) {
                String[] allowedGroups = this.authorizationConfiguration.getAllowedGroups();
                String[] allowedRealms = this.authorizationConfiguration.getAllowedRealms();
                String[] allowedRoles = this.authorizationConfiguration.getAllowedRoles();
                String[] expressions = this.authorizationConfiguration.getExpressions();
                List<Class<? extends PathAuthorizer>> authorizers = this.authorizationConfiguration.getAuthorizers();
                if (allowedGroups == null) {
                    allowedGroups = groupAuthz.getAllowedGroups();
                }
                if (allowedRealms == null) {
                    allowedRealms = groupAuthz.getAllowedRealms();
                }
                if (allowedRoles == null) {
                    allowedRoles = groupAuthz.getAllowedRoles();
                }
                if (expressions == null) {
                    expressions = groupAuthz.getExpressions();
                }
                if (authorizers == null) {
                    authorizers = groupAuthz.getAuthorizers();
                }
                return new AuthorizationConfiguration(this, allowedRoles, allowedGroups, allowedRealms, expressions, authorizers);
            }
            if (groupAuthz != null) {
                return groupConfiguration.getAuthorizationConfiguration();
            }
        }
        return this.authorizationConfiguration;
    }

    protected void setAuthorizationConfiguration(AuthorizationConfiguration authorizationConfiguration) {
        this.authorizationConfiguration = authorizationConfiguration;
    }

    public CORSConfiguration getCORSConfiguration() {
        PathConfiguration pathConfiguration = this;
        if (pathConfiguration.isUri() && pathConfiguration.getGroupName() != null && !pathConfiguration.isDefaultGroup()) {
            Map<String, PathConfiguration> groups = pathConfiguration.getSecurityConfiguration().getGroups();
            PathConfiguration groupConfiguration = groups.get(pathConfiguration.getGroupName());
            CORSConfiguration groupCORSAuthz = groupConfiguration.getCORSConfiguration();
            if (this.corsConfiguration != null && groupCORSAuthz != null) {
                Set<String> allowedOrigins = this.corsConfiguration.getAllowedOrigins();
                Set<String> allowedMethods = this.corsConfiguration.getAllowedMethods();
                Set<String> allowedHeaders = this.corsConfiguration.getAllowedHeaders();
                Set<String> exposedHeaders = this.corsConfiguration.getExposedHeaders();
                boolean allowCredentials = this.corsConfiguration.isAllowCredentials();
                boolean allowAnyOrigin = this.corsConfiguration.isAllowAnyOrigin();
                boolean allowAnyHeader = this.corsConfiguration.isAllowAnyHeader();
                boolean allowAnyMethod = this.corsConfiguration.isAllowAnyMethod();
                long maxAge = this.corsConfiguration.getMaxAge();
                if (allowedOrigins == null) {
                    allowedOrigins = groupCORSAuthz.getAllowedOrigins();
                }
                if (allowedMethods == null) {
                    allowedMethods = groupCORSAuthz.getAllowedMethods();
                }
                if (allowedHeaders == null) {
                    allowedHeaders = groupCORSAuthz.getAllowedHeaders();
                }
                if (exposedHeaders == null) {
                    exposedHeaders = groupCORSAuthz.getExposedHeaders();
                }
                if (Boolean.valueOf(allowCredentials) == null) {
                    allowCredentials = groupCORSAuthz.isAllowCredentials();
                }
                if (Long.valueOf(maxAge) == null) {
                    maxAge = groupCORSAuthz.getMaxAge();
                }
                return new CORSConfiguration(this, allowedOrigins, allowedMethods, allowedHeaders, exposedHeaders, allowCredentials, allowAnyOrigin, allowAnyHeader, allowAnyMethod, maxAge);
            }
            if (groupCORSAuthz != null) {
                return groupConfiguration.getCORSConfiguration();
            }
        }
        return this.corsConfiguration;
    }

    protected void setCORSConfiguration(CORSConfiguration corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    public InboundHeaderConfiguration getInboundHeaderConfiguration() {
        return this.inboundHeaderConfiguration;
    }

    protected void setInboundHeaderConfiguration(InboundHeaderConfiguration inboundHeaderConfiguration) {
        this.inboundHeaderConfiguration = inboundHeaderConfiguration;
    }

    public LogoutConfiguration getLogoutConfiguration() {
        return this.logoutConfiguration;
    }

    protected void setLogoutConfiguration(LogoutConfiguration logoutConfiguration) {
        this.logoutConfiguration = logoutConfiguration;
    }

    public List<OutboundRedirectConfiguration> getRedirects() {
        List<OutboundRedirectConfiguration> redirects;
        if (this.hasGroup() && !(redirects = this.getGroupConfiguration().getRedirects()).isEmpty()) {
            return redirects;
        }
        return this.redirects;
    }

    public String getRedirectUrl(OutboundRedirectConfiguration.Condition condition) {
        String redirectUrl = null;
        if (this.hasGroup()) {
            redirectUrl = this.getGroupConfiguration().getRedirectUrl(condition);
        }
        for (OutboundRedirectConfiguration redirectConfiguration : this.redirects) {
            if (!condition.equals((Object)redirectConfiguration.getCondition())) continue;
            return redirectConfiguration.getRedirectUrl();
        }
        return redirectUrl;
    }

    public String getRedirectUrl(Class<? extends Throwable> exceptionType) {
        String redirectUrl = null;
        if (this.hasGroup()) {
            redirectUrl = this.getGroupConfiguration().getRedirectUrl(exceptionType);
        }
        for (OutboundRedirectConfiguration redirectConfiguration : this.redirects) {
            if (!exceptionType.equals(redirectConfiguration.getExceptionType())) continue;
            return redirectConfiguration.getRedirectUrl();
        }
        return redirectUrl;
    }

    public boolean hasRedirectWhen(OutboundRedirectConfiguration.Condition condition) {
        boolean hasRedirect = false;
        if (this.hasGroup()) {
            hasRedirect = this.getGroupConfiguration().hasRedirectWhen(condition);
        }
        for (OutboundRedirectConfiguration redirectConfiguration : this.redirects) {
            if (!condition.equals((Object)redirectConfiguration.getCondition())) continue;
            return true;
        }
        return hasRedirect;
    }

    public Set<HttpMethod> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    public String toString() {
        return "UriConfiguration{groupName='" + this.groupName + '\'' + ", uri='" + this.uri + '\'' + '}';
    }
}

