/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.core.deployment;

import javax.enterprise.inject.spi.Extension;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.picketlink.as.subsystem.core.PicketLinkCoreSubsystemExtension;
import org.picketlink.as.subsystem.deployment.AbstractCDIDeploymentUnitProcessor;
import org.picketlink.as.subsystem.deployment.PicketLinkModuleIdentifiers;
import org.picketlink.as.subsystem.deployment.PicketLinkStructureDeploymentProcessor;
import org.picketlink.idm.PartitionManager;

public class PicketLinkCoreDeploymentProcessor
extends AbstractCDIDeploymentUnitProcessor {
    public static final Phase PHASE = Phase.POST_MODULE;
    public static final int PRIORITY = 3328;

    @Override
    public void doDeploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deployment = phaseContext.getDeploymentUnit();
        if (PicketLinkStructureDeploymentProcessor.isCoreDeployment(deployment)) {
            if (deployment.getParent() != null) {
                deployment = deployment.getParent();
            }
            this.configureExtensions(deployment);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    @Override
    protected boolean isAlreadyConfigured(DeploymentUnit deployment) {
        return this.hasExtension(deployment, PicketLinkCoreSubsystemExtension.class);
    }

    private void configureExtensions(DeploymentUnit deployment) throws DeploymentUnitProcessingException {
        this.addExtension(deployment, new PicketLinkCoreSubsystemExtension(this.getPartitionManagerJNDIUrl(deployment)));
        try {
            Module module = Module.getBootModuleLoader().loadModule(PicketLinkModuleIdentifiers.ORG_PICKETLINK_CORE_MODULE);
            for (Extension e : module.loadService(Extension.class)) {
                this.addExtension(deployment, e);
            }
        }
        catch (ModuleLoadException e) {
            throw new DeploymentUnitProcessingException("Failed to configure CDI extensions for deployment [" + deployment.getName() + "].", (Throwable)e);
        }
    }

    private String getPartitionManagerJNDIUrl(DeploymentUnit deployment) {
        WarMetaData warMetadata = (WarMetaData)deployment.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetadata != null && warMetadata.getWebMetaData() != null && warMetadata.getWebMetaData().getResourceReferences() != null) {
            ResourceReferencesMetaData resourceReferences = warMetadata.getWebMetaData().getResourceReferences();
            for (ResourceReferenceMetaData resourceReferenceMetaData : resourceReferences) {
                if (!PartitionManager.class.getName().equals(resourceReferenceMetaData.getType())) continue;
                return resourceReferenceMetaData.getName();
            }
        }
        return null;
    }
}

