/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.idm.model;

import java.util.Set;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.picketlink.as.subsystem.PicketLinkMessages;
import org.picketlink.as.subsystem.idm.config.JPAStoreSubsystemConfiguration;
import org.picketlink.as.subsystem.idm.config.JPAStoreSubsystemConfigurationBuilder;
import org.picketlink.as.subsystem.idm.service.PartitionManagerService;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.idm.config.FileStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.LDAPMappingConfigurationBuilder;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.config.NamedIdentityConfigurationBuilder;
import org.picketlink.idm.model.Relationship;

public class IdentityManagementConfiguration {
    public static IdentityStoreConfigurationBuilder configureStore(String storeType, Resource.ResourceEntry resource, NamedIdentityConfigurationBuilder builder, PartitionManagerService partitionManagerService) {
        Set featuresSetEntries;
        JPAStoreSubsystemConfigurationBuilder storeConfig = null;
        ModelNode modelNode = resource.getModel();
        ModelNode alternativeModuleNode = modelNode.get(ModelElement.COMMON_MODULE.getName());
        Module alternativeModule = null;
        if (alternativeModuleNode.isDefined()) {
            ModuleLoader moduleLoader = Module.getContextModuleLoader();
            try {
                alternativeModule = moduleLoader.loadModule(ModuleIdentifier.create((String)alternativeModuleNode.asString()));
            }
            catch (ModuleLoadException e) {
                throw new IllegalStateException("Could not load module [" + alternativeModuleNode.asString() + "].");
            }
        } else {
            alternativeModule = Module.getCallerModule();
        }
        if (storeType.equals(ModelElement.JPA_STORE.getName())) {
            storeConfig = IdentityManagementConfiguration.configureJPAIdentityStore(resource, builder, partitionManagerService);
        } else if (storeType.equals(ModelElement.FILE_STORE.getName())) {
            storeConfig = IdentityManagementConfiguration.configureFileIdentityStore(resource, builder);
        } else if (storeType.equals(ModelElement.LDAP_STORE.getName())) {
            storeConfig = IdentityManagementConfiguration.configureLDAPIdentityStore(alternativeModule, resource, builder);
        } else {
            throw PicketLinkMessages.MESSAGES.idmNoConfigurationProvided();
        }
        ModelNode supportAttributeNode = modelNode.get(ModelElement.IDENTITY_STORE_SUPPORT_ATTRIBUTE.getName());
        storeConfig.supportAttributes(true);
        if (supportAttributeNode.isDefined()) {
            storeConfig.supportAttributes(supportAttributeNode.asBoolean());
        }
        ModelNode supportCredentialNode = modelNode.get(ModelElement.IDENTITY_STORE_SUPPORT_CREDENTIAL.getName());
        storeConfig.supportCredentials(true);
        if (supportCredentialNode.isDefined()) {
            storeConfig.supportCredentials(supportCredentialNode.asBoolean());
        }
        if ((featuresSetEntries = resource.getChildren(ModelElement.SUPPORTED_TYPES.getName())) != null && !featuresSetEntries.isEmpty()) {
            Resource.ResourceEntry featuresSet = (Resource.ResourceEntry)featuresSetEntries.iterator().next();
            IdentityManagementConfiguration.configureAllFeatures(featuresSet.getModel(), (IdentityStoreConfigurationBuilder)storeConfig);
            Set featuresList = featuresSet.getChildren(ModelElement.SUPPORTED_TYPE.getName());
            for (Resource.ResourceEntry feature : featuresList) {
                String typeName = feature.getModel().get(ModelElement.COMMON_CLASS.getName()).asString();
                try {
                    Class<?> attributedTypeClass = IdentityManagementConfiguration.loadClass(alternativeModule, typeName);
                    if (Relationship.class.isAssignableFrom(attributedTypeClass)) {
                        storeConfig.supportGlobalRelationship(new Class[]{attributedTypeClass});
                        continue;
                    }
                    storeConfig.supportType(new Class[]{attributedTypeClass});
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not find type [" + typeName + "].", e);
                }
            }
        }
        Set featuresList = resource.getChildren(ModelElement.IDENTITY_STORE_CREDENTIAL_HANDLER.getName());
        for (Resource.ResourceEntry feature : featuresList) {
            String typeName = feature.getModel().get(ModelElement.COMMON_CLASS.getName()).asString();
            try {
                storeConfig.addCredentialHandler(IdentityManagementConfiguration.loadClass(alternativeModule, typeName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not find type [" + typeName + "].", e);
            }
        }
        return storeConfig;
    }

    private static JPAStoreSubsystemConfigurationBuilder configureJPAIdentityStore(Resource.ResourceEntry resource, NamedIdentityConfigurationBuilder builder, PartitionManagerService partitionManagerService) {
        JPAStoreSubsystemConfigurationBuilder storeConfig = (JPAStoreSubsystemConfigurationBuilder)builder.stores().add(JPAStoreSubsystemConfiguration.class, JPAStoreSubsystemConfigurationBuilder.class);
        ModelNode jpaDataSourceNode = resource.getModel().get(ModelElement.JPA_STORE_DATASOURCE.getName());
        ModelNode jpaEntityModule = resource.getModel().get(ModelElement.JPA_STORE_ENTITY_MODULE.getName());
        ModelNode jpaEntityModuleUnitName = resource.getModel().get(ModelElement.JPA_STORE_ENTITY_MODULE_UNIT_NAME.getName());
        ModelNode jpaEntityManagerFactoryNode = resource.getModel().get(ModelElement.JPA_STORE_ENTITY_MANAGER_FACTORY.getName());
        if (jpaEntityModule.isDefined()) {
            storeConfig.entityModule(jpaEntityModule.asString());
        }
        if (jpaEntityModuleUnitName.isDefined()) {
            storeConfig.entityModuleUnitName(jpaEntityModuleUnitName.asString());
        }
        if (jpaDataSourceNode.isDefined()) {
            storeConfig.dataSourceJndiUrl(IdentityManagementConfiguration.toJndiName(jpaDataSourceNode.asString()));
        }
        if (jpaEntityManagerFactoryNode.isDefined()) {
            storeConfig.entityManagerFactoryJndiName(jpaEntityManagerFactoryNode.asString());
        }
        storeConfig.transactionManager(partitionManagerService.getTransactionManager());
        return storeConfig;
    }

    private static Class<?> loadClass(Module module, String typeName) throws ClassNotFoundException {
        if (module != null) {
            return module.getClassLoader().loadClass(typeName);
        }
        return Class.forName(typeName);
    }

    private static void configureAllFeatures(ModelNode operation, IdentityStoreConfigurationBuilder storeConfig) {
        ModelNode supportsAll = operation.get(ModelElement.COMMON_SUPPORTS_ALL.getName());
        if (supportsAll.isDefined() && supportsAll.asBoolean()) {
            storeConfig.supportAllFeatures();
        }
    }

    private static IdentityStoreConfigurationBuilder configureFileIdentityStore(Resource.ResourceEntry resource, NamedIdentityConfigurationBuilder builder) {
        ModelNode modelNode = resource.getModel();
        FileStoreConfigurationBuilder fileStoreBuilder = builder.stores().file();
        ModelNode workingDir = modelNode.get(ModelElement.FILE_STORE_WORKING_DIR.getName());
        ModelNode alwaysCreateFiles = modelNode.get(ModelElement.FILE_STORE_ALWAYS_CREATE_FILE.getName());
        ModelNode asyncWrite = modelNode.get(ModelElement.FILE_STORE_ASYNC_WRITE.getName());
        ModelNode asyncWriteThreadPool = modelNode.get(ModelElement.FILE_STORE_ASYNC_THREAD_POOL.getName());
        if (workingDir.isDefined()) {
            fileStoreBuilder.workingDirectory(workingDir.asString());
        }
        if (alwaysCreateFiles.isDefined()) {
            fileStoreBuilder.preserveState(!alwaysCreateFiles.asBoolean());
        }
        if (asyncWrite.isDefined()) {
            fileStoreBuilder.asyncWrite(asyncWrite.asBoolean());
        }
        if (asyncWriteThreadPool.isDefined()) {
            fileStoreBuilder.asyncWriteThreadPool(asyncWriteThreadPool.asInt());
        }
        return fileStoreBuilder;
    }

    private static LDAPStoreConfigurationBuilder configureLDAPIdentityStore(Module alternativeModule, Resource.ResourceEntry resource, NamedIdentityConfigurationBuilder builder) {
        ModelNode modelNode = resource.getModel();
        LDAPStoreConfigurationBuilder storeConfig = builder.stores().ldap();
        ModelNode url = modelNode.get(ModelElement.LDAP_STORE_URL.getName());
        ModelNode bindDn = modelNode.get(ModelElement.LDAP_STORE_BIND_DN.getName());
        ModelNode bindCredential = modelNode.get(ModelElement.LDAP_STORE_BIND_CREDENTIAL.getName());
        ModelNode baseDn = modelNode.get(ModelElement.LDAP_STORE_BASE_DN_SUFFIX.getName());
        if (url.isDefined()) {
            storeConfig.url(url.asString());
        }
        if (bindDn.isDefined()) {
            storeConfig.bindDN(bindDn.asString());
        }
        if (bindCredential.isDefined()) {
            storeConfig.bindCredential(bindCredential.asString());
        }
        if (baseDn.isDefined()) {
            storeConfig.baseDN(baseDn.asString());
        }
        Set mappings = resource.getChildren(ModelElement.LDAP_STORE_MAPPING.getName());
        for (Resource.ResourceEntry mapping : mappings) {
            LDAPMappingConfigurationBuilder storeMapping;
            ModelNode mappingModelNode = mapping.getModel();
            String mappingClass = mappingModelNode.get(ModelElement.LDAP_STORE_MAPPING_CLASS.getName()).asString();
            try {
                storeMapping = storeConfig.mapping(IdentityManagementConfiguration.loadClass(alternativeModule, mappingClass));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load LDAP mapped class [" + mappingClass + "].", e);
            }
            ModelNode relatesTo = mappingModelNode.get(ModelElement.LDAP_STORE_MAPPING_RELATES_TO.getName());
            if (relatesTo.isDefined()) {
                try {
                    storeMapping.forMapping(IdentityManagementConfiguration.loadClass(alternativeModule, relatesTo.asString()));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not load LDAP mapped class [" + mappingClass + "].", e);
                }
            } else {
                String baseDN = mappingModelNode.get(ModelElement.LDAP_STORE_MAPPING_BASE_DN.getName()).asString();
                storeMapping.baseDN(baseDN);
                String objectClasses = mappingModelNode.get(ModelElement.LDAP_STORE_MAPPING_OBJECT_CLASSES.getName()).asString();
                for (String objClass : objectClasses.split(",")) {
                    if (objClass.trim().isEmpty()) continue;
                    storeMapping.objectClasses(new String[]{objClass});
                }
                ModelNode parentAttributeName = mappingModelNode.get(ModelElement.LDAP_STORE_MAPPING_PARENT_ATTRIBUTE_NAME.getName());
                if (parentAttributeName.isDefined()) {
                    storeMapping.parentMembershipAttributeName(parentAttributeName.asString());
                }
            }
            Set attributes = mapping.getChildren(ModelElement.LDAP_STORE_ATTRIBUTE.getName());
            for (Resource.ResourceEntry attribute : attributes) {
                ModelNode attributeModel = attribute.getModel();
                String name = attributeModel.get(ModelElement.LDAP_STORE_ATTRIBUTE_NAME.getName()).asString();
                String ldapName = attributeModel.get(ModelElement.LDAP_STORE_ATTRIBUTE_LDAP_NAME.getName()).asString();
                ModelNode readOnlyModelNode = attributeModel.get(ModelElement.LDAP_STORE_ATTRIBUTE_READ_ONLY.getName());
                if (readOnlyModelNode.isDefined() && readOnlyModelNode.asBoolean()) {
                    storeMapping.readOnlyAttribute(name, ldapName);
                    continue;
                }
                ModelNode identifierModelNode = attributeModel.get(ModelElement.LDAP_STORE_ATTRIBUTE_IS_IDENTIFIER.getName());
                boolean isIdentifier = false;
                if (identifierModelNode.isDefined()) {
                    isIdentifier = identifierModelNode.asBoolean();
                }
                storeMapping.attribute(name, ldapName, isIdentifier);
            }
        }
        return storeConfig;
    }

    public static String toJndiName(String jndiName) {
        if (jndiName != null && jndiName.startsWith("java:")) {
            jndiName = jndiName.substring(jndiName.indexOf(":") + 1);
        }
        return jndiName;
    }
}

