/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.federation.model.handlers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.picketlink.as.subsystem.federation.service.AbstractEntityProviderService;
import org.picketlink.as.subsystem.federation.service.IdentityProviderService;
import org.picketlink.as.subsystem.federation.service.ServiceProviderService;
import org.picketlink.as.subsystem.model.AbstractResourceAddStepHandler;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.config.federation.KeyValueType;
import org.picketlink.config.federation.handler.Handler;
import org.picketlink.config.federation.handler.Handlers;

public class HandlerParameterAddHandler
extends AbstractResourceAddStepHandler {
    public static final HandlerParameterAddHandler INSTANCE = new HandlerParameterAddHandler();

    private HandlerParameterAddHandler() {
        super(ModelElement.COMMON_HANDLER_PARAMETER);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String providerAlias = ((Property)operation.get("address").asPropertyList().get(2)).getValue().asString();
        String handlerClassName = ((Property)operation.get("address").asPropertyList().get(3)).getValue().asString();
        String paramName = operation.get(ModelElement.COMMON_NAME.getName()).asString();
        String paramValue = operation.get(ModelElement.COMMON_VALUE.getName()).asString();
        AbstractEntityProviderService providerService = this.getParentProviderService(context, providerAlias);
        Handlers handlerChain = providerService.getPicketLinkType().getHandlers();
        for (Handler handler : new ArrayList(handlerChain.getHandler())) {
            if (!handler.getClazz().equals(handlerClassName)) continue;
            KeyValueType kv = new KeyValueType();
            kv.setKey(paramName);
            kv.setValue(paramValue);
            handler.add(kv);
        }
    }

    private AbstractEntityProviderService getParentProviderService(OperationContext context, String providerAlias) {
        AbstractEntityProviderService providerService = IdentityProviderService.getService(context.getServiceRegistry(true), providerAlias);
        if (providerService == null) {
            providerService = ServiceProviderService.getService(context.getServiceRegistry(true), providerAlias);
        }
        return providerService;
    }
}

