/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.federation.model.sp;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.picketlink.as.subsystem.federation.model.sp.ServiceProviderResourceDefinition;
import org.picketlink.as.subsystem.federation.service.FederationService;
import org.picketlink.as.subsystem.federation.service.ServiceProviderService;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.as.subsystem.model.ModelUtils;
import org.picketlink.identity.federation.core.config.SPConfiguration;

public class SPWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final SPWriteAttributeHandler INSTANCE = new SPWriteAttributeHandler();

    private SPWriteAttributeHandler() {
        super(new AttributeDefinition[]{ServiceProviderResourceDefinition.ALIAS, ServiceProviderResourceDefinition.POST_BINDING, ServiceProviderResourceDefinition.SECURITY_DOMAIN, ServiceProviderResourceDefinition.SUPPORTS_SIGNATURES, ServiceProviderResourceDefinition.URL, ServiceProviderResourceDefinition.STRICT_POST_BINDING, ServiceProviderResourceDefinition.ERROR_PAGE});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode node = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        String alias = node.get(ModelElement.COMMON_ALIAS.getName()).asString();
        ServiceProviderService service = (ServiceProviderService)context.getServiceRegistry(true).getRequiredService(ServiceProviderService.createServiceName(alias)).getValue();
        SPConfiguration updatedSPConfig = ModelUtils.toSPConfig(node);
        updatedSPConfig.setKeyProvider(FederationService.getService(context.getServiceRegistry(true), operation).getKeyProvider());
        service.setConfiguration(updatedSPConfig);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
    }
}

