/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.federation.service;

import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.web.ext.WebContextFactory;
import org.picketlink.as.subsystem.federation.metrics.PicketLinkSubsystemMetrics;
import org.picketlink.as.subsystem.federation.service.DomainModelConfigProvider;
import org.picketlink.identity.federation.bindings.tomcat.idp.IDPWebBrowserSSOValve;
import org.picketlink.identity.federation.bindings.tomcat.sp.ServiceProviderAuthenticator;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;

public class PicketLinkWebContextFactory
implements WebContextFactory {
    private final DomainModelConfigProvider configProvider;
    private PicketLinkSubsystemMetrics auditHelper;

    public PicketLinkWebContextFactory(DomainModelConfigProvider picketLinkSubsysteConfigProvider, PicketLinkSubsystemMetrics metrics) {
        this.configProvider = picketLinkSubsysteConfigProvider;
        this.auditHelper = metrics;
    }

    public StandardContext createContext(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        return new StandardContext();
    }

    public void postProcessContext(DeploymentUnit deploymentUnit, StandardContext webContext) {
        if (this.configProvider.isIdentityProviderConfiguration()) {
            this.addIdentityProviderValves(webContext);
        } else {
            this.addServiceProviderValves(webContext);
        }
    }

    private void addServiceProviderValves(StandardContext webContext) {
        ServiceProviderAuthenticator valve = new ServiceProviderAuthenticator();
        valve.setConfigProvider((SAMLConfigurationProvider)this.configProvider);
        valve.setAuditHelper((PicketLinkAuditHelper)this.auditHelper);
        webContext.addValve((Valve)valve);
    }

    private void addIdentityProviderValves(StandardContext webContext) {
        IDPWebBrowserSSOValve valve = new IDPWebBrowserSSOValve();
        valve.setConfigProvider((SAMLConfigurationProvider)this.configProvider);
        valve.setAuditHelper((PicketLinkAuditHelper)this.auditHelper);
        webContext.addValve((Valve)valve);
    }
}

