/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.idm.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.metamodel.EntityType;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.jpa.hibernate4.JBossAppServerJtaPlatform;
import org.jboss.as.jpa.transaction.JtaManagerImpl;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.value.InjectedValue;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;

public class JPAStoreSubsystemConfiguration
extends JPAIdentityStoreConfiguration {
    private static final String JPA_ANNOTATION_PACKAGE = "org.picketlink.idm.jpa.annotations";
    private EntityManagerFactory emf;
    private String entityModuleUnitName = "identity";
    private final Module entityModule;
    private final String dataSourceJndiUrl;
    private final String entityManagerFactoryJndiName;
    private InjectedValue<TransactionManager> transactionManager;

    protected JPAStoreSubsystemConfiguration(String entityModuleName, String entityModuleUnitName, String dataSourceJndiUrl, String entityManagerFactoryJndiName, InjectedValue<TransactionManager> transactionManager, Set<Class<?>> entityTypes, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> supportedTypes, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> unsupportedTypes, List<ContextInitializer> contextInitializers, Map<String, Object> credentialHandlerProperties, Set<Class<? extends CredentialHandler>> credentialHandlers, boolean supportsAttribute, boolean supportsCredential) {
        super(entityTypes, supportedTypes, unsupportedTypes, contextInitializers, credentialHandlerProperties, credentialHandlers, supportsAttribute, supportsCredential);
        this.transactionManager = transactionManager;
        if (entityModuleName != null) {
            ModuleLoader moduleLoader = Module.getContextModuleLoader();
            try {
                this.entityModule = moduleLoader.loadModule(ModuleIdentifier.create((String)entityModuleName));
            }
            catch (ModuleLoadException e) {
                throw new SecurityConfigurationException("Entities module not found [" + entityModuleName + "].");
            }
        } else {
            this.entityModule = null;
        }
        this.entityModuleUnitName = entityModuleUnitName;
        this.dataSourceJndiUrl = dataSourceJndiUrl;
        this.entityManagerFactoryJndiName = entityManagerFactoryJndiName;
        try {
            this.configureEntityManagerFactory();
            this.configureEntities();
        }
        catch (Exception e) {
            throw new SecurityConfigurationException("Could not configure JPA store.", (Throwable)e);
        }
    }

    public void initializeContext(IdentityContext context, IdentityStore<?> store) {
        if (store instanceof JPAIdentityStore && !context.isParameterSet("CTX_ENTITY_MANAGER")) {
            context.setParameter("CTX_ENTITY_MANAGER", (Object)this.getEntityManager());
        }
    }

    public Class<? extends IdentityStore> getIdentityStoreType() {
        return JPAIdentityStore.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManagerFactory createEmbeddedEntityManagerFactory() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (!StringUtil.isNullOrEmpty((String)this.dataSourceJndiUrl)) {
                properties.put("javax.persistence.jtaDataSource", this.dataSourceJndiUrl);
            }
            properties.put("hibernate.transaction.jta.platform", (String)new JBossAppServerJtaPlatform(JtaManagerImpl.getInstance()));
            if (this.entityModule != null) {
                Thread.currentThread().setContextClassLoader((ClassLoader)this.entityModule.getClassLoader());
            }
            EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)this.entityModuleUnitName, properties);
            return entityManagerFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void configureEntities() {
        Set mappedEntities = this.emf.getMetamodel().getEntities();
        for (EntityType entity : mappedEntities) {
            Class javaType = entity.getJavaType();
            if (Modifier.isAbstract(javaType.getModifiers()) || !this.isIdentityEntity(javaType)) continue;
            this.getEntityTypes().add(javaType);
        }
    }

    private boolean isIdentityEntity(Class<?> cls) {
        while (!cls.equals(Object.class)) {
            for (Annotation a : cls.getAnnotations()) {
                if (!a.annotationType().getName().startsWith(JPA_ANNOTATION_PACKAGE)) continue;
                return true;
            }
            for (Field f : cls.getDeclaredFields()) {
                for (Annotation a : f.getAnnotations()) {
                    if (!a.annotationType().getName().startsWith(JPA_ANNOTATION_PACKAGE)) continue;
                    return true;
                }
            }
            cls = cls.getSuperclass();
        }
        return false;
    }

    private void configureEntityManagerFactory() {
        this.emf = this.entityManagerFactoryJndiName != null ? this.lookupEntityManagerFactory() : this.createEmbeddedEntityManagerFactory();
    }

    private EntityManagerFactory lookupEntityManagerFactory() {
        try {
            return (EntityManagerFactory)new InitialContext().lookup(this.entityManagerFactoryJndiName);
        }
        catch (NamingException e) {
            throw new SecurityConfigurationException("Could not lookup EntityManagerFactory [" + this.entityManagerFactoryJndiName + "].");
        }
    }

    private EntityManager getEntityManager() {
        return (EntityManager)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{EntityManager.class}, (InvocationHandler)new EntityManagerInvocationHandler(this.emf.createEntityManager(), this.entityModule));
    }

    private class EntityManagerInvocationHandler
    implements InvocationHandler {
        private final EntityManager em;
        private final Module entityModule;

        public EntityManagerInvocationHandler(EntityManager em, Module entitiesModule) {
            this.em = em;
            this.entityModule = entitiesModule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Transaction tx = null;
            if (this.isTxRequired(method, args)) {
                if (((TransactionManager)JPAStoreSubsystemConfiguration.this.transactionManager.getValue()).getStatus() == 6) {
                    ((TransactionManager)JPAStoreSubsystemConfiguration.this.transactionManager.getValue()).begin();
                    tx = ((TransactionManager)JPAStoreSubsystemConfiguration.this.transactionManager.getValue()).getTransaction();
                }
                this.em.joinTransaction();
            }
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (this.entityModule != null) {
                    Thread.currentThread().setContextClassLoader((ClassLoader)this.entityModule.getClassLoader());
                }
                Object object = method.invoke((Object)this.em, args);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
                if (tx != null) {
                    tx.commit();
                    ((TransactionManager)JPAStoreSubsystemConfiguration.this.transactionManager.getValue()).suspend();
                }
            }
        }

        private boolean isTxRequired(Method method, Object[] args) {
            String n = method.getName();
            if (n.equals("flush")) {
                return true;
            }
            if (n.equals("getLockMode")) {
                return true;
            }
            if (n.equals("lock")) {
                return true;
            }
            if (n.equals("merge")) {
                return true;
            }
            if (n.equals("persist")) {
                return true;
            }
            if (n.equals("refresh")) {
                return true;
            }
            return n.equals("remove");
        }
    }
}

