/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.deployment;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;
import org.picketlink.as.subsystem.PicketLinkLogger;
import org.picketlink.as.subsystem.deployment.PicketLinkModuleIdentifiers;
import org.picketlink.as.subsystem.deployment.PicketLinkStructureDeploymentProcessor;

public class PicketLinkDependencyDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final Phase PHASE = Phase.DEPENDENCIES;
    public static final int PRIORITY = 1;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deployment = phaseContext.getDeploymentUnit();
        if (PicketLinkStructureDeploymentProcessor.isFederationDeployment(deployment)) {
            this.configureFederationDependencies(deployment);
        }
        if (PicketLinkStructureDeploymentProcessor.isCoreDeployment(deployment)) {
            this.configureCoreDependencies(deployment);
        }
        if (PicketLinkStructureDeploymentProcessor.isIDMDeployment(deployment)) {
            this.configureIDMDependencies(deployment);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void configureFederationDependencies(DeploymentUnit deployment) {
        this.addModuleDependency(deployment, PicketLinkModuleIdentifiers.ORG_PICKETLINK_MODULE);
        this.addModuleDependency(deployment, PicketLinkModuleIdentifiers.ORG_PICKETLINK_AS_EXTENSION_MODULE);
        PicketLinkLogger.ROOT_LOGGER.configuringDeployment("PicketLink Federation Dependencies", deployment.getName());
    }

    private void configureIDMDependencies(DeploymentUnit deployment) {
        this.addModuleDependency(deployment, PicketLinkModuleIdentifiers.ORG_PICKETLINK_IDM_API_MODULE);
        this.addModuleDependency(deployment, PicketLinkModuleIdentifiers.ORG_PICKETLINK_IDM_MODULE);
        this.addModuleDependency(deployment, PicketLinkModuleIdentifiers.ORG_PICKETLINK_AS_EXTENSION_MODULE);
        PicketLinkLogger.ROOT_LOGGER.configuringDeployment("PicketLink IDM Dependencies", deployment.getName());
    }

    private void configureCoreDependencies(DeploymentUnit deployment) {
        this.addModuleDependency(deployment, PicketLinkModuleIdentifiers.ORG_PICKETLINK_CORE_API_MODULE);
        this.addModuleDependency(deployment, PicketLinkModuleIdentifiers.ORG_PICKETLINK_CORE_MODULE);
        this.addModuleDependency(deployment, PicketLinkModuleIdentifiers.ORG_PICKETLINK_AS_EXTENSION_MODULE);
        PicketLinkLogger.ROOT_LOGGER.configuringDeployment("PicketLink Core Dependencies", deployment.getName());
    }

    private void addModuleDependency(DeploymentUnit deployment, ModuleIdentifier moduleIdentifier) {
        ModuleSpecification moduleSpec = (ModuleSpecification)deployment.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = (ModuleLoader)deployment.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        ModuleDependency dependency = new ModuleDependency(moduleLoader, moduleIdentifier, false, true, true, false);
        dependency.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpec.addSystemDependency(dependency);
    }
}

