/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.federation.service;

import java.util.HashMap;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.picketlink.as.subsystem.federation.service.AbstractEntityProviderService;
import org.picketlink.as.subsystem.model.ModelUtils;
import org.picketlink.identity.federation.core.config.IDPConfiguration;
import org.picketlink.identity.federation.core.config.PicketLinkConfigUtil;
import org.picketlink.identity.federation.core.config.SPConfiguration;
import org.picketlink.identity.federation.web.handlers.saml2.RolesGenerationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2AuthenticationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2LogOutHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2SignatureGenerationHandler;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2SignatureValidationHandler;

public class ServiceProviderService
extends AbstractEntityProviderService<ServiceProviderService, SPConfiguration> {
    private static final String SERVICE_NAME = "SPConfigurationService";

    public ServiceProviderService(OperationContext context, ModelNode modelNode) {
        super(context, modelNode);
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.setConfiguration(null);
    }

    @Override
    public void doConfigureDeployment(DeploymentUnit deploymentUnit) {
        this.configureBindingType();
    }

    private void configureBindingType() {
        if (this.getConfiguration().isPostBinding()) {
            this.getConfiguration().setBindingType("POST");
        } else {
            this.getConfiguration().setBindingType("REDIRECT");
        }
    }

    @Override
    protected void doAddHandlers() {
        PicketLinkConfigUtil.addHandler(SAML2LogOutHandler.class, this.getPicketLinkType());
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("CLOCK_SKEW_MILIS", String.valueOf(this.getPicketLinkType().getStsType().getClockSkew()));
        PicketLinkConfigUtil.addHandler(SAML2AuthenticationHandler.class, options, this.getPicketLinkType());
        PicketLinkConfigUtil.addHandler(RolesGenerationHandler.class, this.getPicketLinkType());
        PicketLinkConfigUtil.addHandler(SAML2SignatureGenerationHandler.class, this.getPicketLinkType());
        PicketLinkConfigUtil.addHandler(SAML2SignatureValidationHandler.class, this.getPicketLinkType());
    }

    public static ServiceName createServiceName(String alias) {
        return ServiceName.JBOSS.append(new String[]{SERVICE_NAME, alias});
    }

    public static ServiceProviderService getService(ServiceRegistry registry, String name) {
        ServiceController container = registry.getService(ServiceProviderService.createServiceName(name));
        if (container != null) {
            return (ServiceProviderService)container.getValue();
        }
        return null;
    }

    @Override
    public SPConfiguration getConfiguration() {
        SPConfiguration configuration = (SPConfiguration)super.getConfiguration();
        if (this.getFederationService().getIdentityProviderService() != null) {
            configuration.setIdentityURL(((IDPConfiguration)this.getFederationService().getIdentityProviderService().getConfiguration()).getIdentityURL());
        }
        return configuration;
    }

    @Override
    protected SPConfiguration toProviderType(ModelNode operation) {
        return ModelUtils.toSPConfig(operation);
    }
}

