/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.idm.model;

import java.util.List;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.value.InjectedValue;
import org.picketlink.as.subsystem.idm.config.JPAStoreSubsystemConfigurationBuilder;
import org.picketlink.as.subsystem.idm.model.IdentityManagementConfiguration;
import org.picketlink.as.subsystem.idm.service.PartitionManagerService;
import org.picketlink.as.subsystem.model.AbstractResourceAddStepHandler;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.NamedIdentityConfigurationBuilder;

public class IdentityManagementAddHandler
extends AbstractResourceAddStepHandler {
    public static final IdentityManagementAddHandler INSTANCE = new IdentityManagementAddHandler();

    private IdentityManagementAddHandler() {
        super(ModelElement.IDENTITY_MANAGEMENT);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String alias = operation.get(ModelElement.COMMON_ALIAS.getName()).asString();
        ModelNode jndiNameNode = operation.get(ModelElement.IDENTITY_MANAGEMENT_JNDI_NAME.getName());
        String jndiName = jndiNameNode.isDefined() ? IdentityManagementConfiguration.toJndiName(jndiNameNode.asString()) : null;
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        PartitionManagerService partitionManagerService = new PartitionManagerService(alias, jndiName, builder);
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(PartitionManagerService.createServiceName(alias), (Service)partitionManagerService);
        this.configureDependencies(partitionManagerService, (ServiceBuilder<PartitionManager>)serviceBuilder);
        for (Resource.ResourceEntry identityConfigurationResource : context.readResource(PathAddress.EMPTY_ADDRESS).getChildren(ModelElement.IDENTITY_CONFIGURATION.getName())) {
            NamedIdentityConfigurationBuilder namedIdentityConfigurationBuilder = builder.named(identityConfigurationResource.getName());
            Set identityStoreTypes = identityConfigurationResource.getChildTypes();
            for (String storeType : identityStoreTypes) {
                for (Resource.ResourceEntry identityStoreResource : identityConfigurationResource.getChildren(storeType)) {
                    IdentityStoreConfigurationBuilder storeConfig = IdentityManagementConfiguration.configureStore(storeType, identityStoreResource, namedIdentityConfigurationBuilder, partitionManagerService);
                    if (!this.isJPAIdentityStoreConfiguration(storeConfig)) continue;
                    this.configureJPAStoreDependencies((ServiceBuilder<PartitionManager>)serviceBuilder, identityStoreResource);
                }
            }
        }
        ServiceController controller = serviceBuilder.addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.PASSIVE).install();
        newControllers.add(controller);
    }

    private boolean isJPAIdentityStoreConfiguration(IdentityStoreConfigurationBuilder storeConfig) {
        return JPAStoreSubsystemConfigurationBuilder.class.isInstance(storeConfig);
    }

    private void configureDependencies(PartitionManagerService partitionManagerService, ServiceBuilder<PartitionManager> serviceBuilder) {
        serviceBuilder.addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, partitionManagerService.getTransactionManager());
    }

    private void configureJPAStoreDependencies(ServiceBuilder<PartitionManager> serviceBuilder, Resource.ResourceEntry identityStoreResource) {
        ModelNode jpaDataSourceNode = identityStoreResource.getModel().get(ModelElement.JPA_STORE_DATASOURCE.getName());
        ModelNode jpaEntityManagerFactoryNode = identityStoreResource.getModel().get(ModelElement.JPA_STORE_ENTITY_MANAGER_FACTORY.getName());
        String dataSourceJndiName = null;
        if (jpaDataSourceNode.isDefined()) {
            dataSourceJndiName = jpaDataSourceNode.asString();
        }
        if ((dataSourceJndiName = IdentityManagementConfiguration.toJndiName(dataSourceJndiName)) != null) {
            serviceBuilder.addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(dataSourceJndiName.split("/")));
        }
        String emfJndiName = null;
        if (jpaEntityManagerFactoryNode.isDefined()) {
            emfJndiName = jpaEntityManagerFactoryNode.asString();
        }
        if (emfJndiName != null) {
            serviceBuilder.addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(emfJndiName.split("/")), ValueManagedReferenceFactory.class, (Injector)new InjectedValue());
        }
    }
}

