/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.parser;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.picketlink.as.subsystem.Namespace;
import org.picketlink.as.subsystem.federation.model.FederationResourceDefinition;
import org.picketlink.as.subsystem.federation.model.KeyProviderResourceDefinition;
import org.picketlink.as.subsystem.federation.model.handlers.HandlerParameterResourceDefinition;
import org.picketlink.as.subsystem.federation.model.handlers.HandlerResourceDefinition;
import org.picketlink.as.subsystem.federation.model.idp.IdentityProviderResourceDefinition;
import org.picketlink.as.subsystem.federation.model.idp.TrustDomainResourceDefinition;
import org.picketlink.as.subsystem.federation.model.saml.SAMLResourceDefinition;
import org.picketlink.as.subsystem.federation.model.sp.ServiceProviderResourceDefinition;
import org.picketlink.as.subsystem.idm.model.CredentialHandlerResourceDefinition;
import org.picketlink.as.subsystem.idm.model.FileStoreResourceDefinition;
import org.picketlink.as.subsystem.idm.model.IdentityConfigurationResourceDefinition;
import org.picketlink.as.subsystem.idm.model.IdentityManagementResourceDefinition;
import org.picketlink.as.subsystem.idm.model.JPAStoreResourceDefinition;
import org.picketlink.as.subsystem.idm.model.LDAPStoreAttributeResourceDefinition;
import org.picketlink.as.subsystem.idm.model.LDAPStoreMappingResourceDefinition;
import org.picketlink.as.subsystem.idm.model.LDAPStoreResourceDefinition;
import org.picketlink.as.subsystem.idm.model.SupportedTypeResourceDefinition;
import org.picketlink.as.subsystem.idm.model.SupportedTypesResourceDefinition;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.as.subsystem.model.XMLElement;

public class PicketLinkSubsystemReader_1_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        Namespace nameSpace = Namespace.forUri(reader.getNamespaceURI());
        ModelNode subsystemNode = this.createSubsystemRoot();
        list.add(subsystemNode);
        switch (nameSpace) {
            case PICKETLINK_1_0: {
                this.readElement_1_0(reader, list, subsystemNode);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void readElement_1_0(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentNode) throws XMLStreamException {
        if (Namespace.PICKETLINK_1_0 != Namespace.forUri(reader.getNamespaceURI())) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode federationNode = null;
        ModelNode lastProviderNode = null;
        ModelNode lastHandlerNode = null;
        ModelNode identityManagementNode = null;
        ModelNode identityConfigurationNode = null;
        ModelNode lastIdentityStoreNode = null;
        ModelNode lastLDAPMappingNode = null;
        ModelNode lastFeatures = null;
        block20: while (reader.hasNext() && reader.nextTag() != 8) {
            if (!reader.isStartElement() || XMLElement.forName(reader.getLocalName()) != null) continue;
            ModelElement modelKey = ModelElement.forName(reader.getLocalName());
            if (modelKey == null) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (modelKey) {
                case FEDERATION: {
                    federationNode = this.parseFederationConfig(reader, list, parentNode);
                    continue block20;
                }
                case KEY_STORE: {
                    this.parseKeyStoreConfig(reader, list, federationNode);
                    continue block20;
                }
                case IDENTITY_PROVIDER: {
                    lastProviderNode = this.parseIdentityProviderConfig(reader, list, federationNode);
                    continue block20;
                }
                case IDENTITY_PROVIDER_TRUST_DOMAIN: {
                    this.parseTrustDomainConfig(reader, list, lastProviderNode);
                    continue block20;
                }
                case COMMON_HANDLER: {
                    lastHandlerNode = this.parseHandlerConfig(reader, list, lastProviderNode);
                    continue block20;
                }
                case COMMON_HANDLER_PARAMETER: {
                    this.parseHandlerParameterConfig(reader, list, lastHandlerNode);
                    continue block20;
                }
                case SERVICE_PROVIDER: {
                    lastProviderNode = this.parseServiceProviderConfig(reader, list, federationNode);
                    continue block20;
                }
                case SAML: {
                    this.parseSAMLConfig(reader, list, federationNode);
                    continue block20;
                }
                case IDENTITY_MANAGEMENT: {
                    identityManagementNode = this.parseIdentityManagementConfig(reader, list, parentNode);
                    continue block20;
                }
                case IDENTITY_CONFIGURATION: {
                    identityConfigurationNode = this.parseIdentityConfigurationConfig(reader, list, identityManagementNode);
                    continue block20;
                }
                case JPA_STORE: {
                    lastIdentityStoreNode = this.parseJPAStoreConfig(reader, list, identityConfigurationNode);
                    continue block20;
                }
                case FILE_STORE: {
                    lastIdentityStoreNode = this.parseFileStoreConfig(reader, list, identityConfigurationNode);
                    continue block20;
                }
                case LDAP_STORE: {
                    lastIdentityStoreNode = this.parseLDAPStoreConfig(reader, list, identityConfigurationNode);
                    continue block20;
                }
                case LDAP_STORE_MAPPING: {
                    lastLDAPMappingNode = this.parseLDAPMappingConfig(reader, list, lastIdentityStoreNode);
                    continue block20;
                }
                case LDAP_STORE_ATTRIBUTE: {
                    this.parseLDAPAttributeConfig(reader, list, lastLDAPMappingNode);
                    continue block20;
                }
                case IDENTITY_STORE_CREDENTIAL_HANDLER: {
                    this.parseCredentialHandlerConfig(reader, list, lastIdentityStoreNode);
                    continue block20;
                }
                case SUPPORTED_TYPES: {
                    lastFeatures = this.parseSupportedTypesConfig(reader, list, lastIdentityStoreNode);
                    continue block20;
                }
                case SUPPORTED_TYPE: {
                    this.parseSupportedTypeConfig(reader, list, lastFeatures);
                    continue block20;
                }
            }
            ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseKeyStoreConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode federationNode) throws XMLStreamException {
        this.parseConfig(reader, ModelElement.KEY_STORE, KeyProviderResourceDefinition.SIGN_KEY_ALIAS.getName(), list, federationNode, KeyProviderResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseServiceProviderConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode federationNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.SERVICE_PROVIDER, ServiceProviderResourceDefinition.ALIAS.getName(), list, federationNode, ServiceProviderResourceDefinition.INSTANCE.getAttributes());
    }

    private void parseSAMLConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode federationNode) throws XMLStreamException {
        this.parseConfig(reader, ModelElement.SAML, null, list, federationNode, SAMLResourceDefinition.INSTANCE.getAttributes());
    }

    private void parseTrustDomainConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode identityProviderNode) throws XMLStreamException {
        this.parseConfig(reader, ModelElement.IDENTITY_PROVIDER_TRUST_DOMAIN, TrustDomainResourceDefinition.NAME.getName(), list, identityProviderNode, TrustDomainResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseHandlerConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode identityProviderNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.COMMON_HANDLER, HandlerResourceDefinition.CLASS.getName(), list, identityProviderNode, HandlerResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseHandlerParameterConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode identityProviderNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.COMMON_HANDLER_PARAMETER, HandlerParameterResourceDefinition.NAME.getName(), list, identityProviderNode, HandlerParameterResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseIdentityProviderConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode federationNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.IDENTITY_PROVIDER, IdentityProviderResourceDefinition.ALIAS.getName(), list, federationNode, IdentityProviderResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseFederationConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.FEDERATION, FederationResourceDefinition.ALIAS.getName(), list, parentNode, FederationResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseIdentityManagementConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.IDENTITY_MANAGEMENT, IdentityManagementResourceDefinition.ALIAS.getName(), list, parentNode, IdentityManagementResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseIdentityConfigurationConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.IDENTITY_CONFIGURATION, IdentityConfigurationResourceDefinition.NAME.getName(), list, parentNode, IdentityConfigurationResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseJPAStoreConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode identityManagementNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.JPA_STORE, null, list, identityManagementNode, JPAStoreResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseFileStoreConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode identityManagementNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.FILE_STORE, null, list, identityManagementNode, FileStoreResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseLDAPStoreConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode identityManagementNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.LDAP_STORE, null, list, identityManagementNode, LDAPStoreResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseLDAPMappingConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode identityProviderNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.LDAP_STORE_MAPPING, LDAPStoreMappingResourceDefinition.CLASS.getName(), list, identityProviderNode, LDAPStoreMappingResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseCredentialHandlerConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode identityProviderNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.IDENTITY_STORE_CREDENTIAL_HANDLER, CredentialHandlerResourceDefinition.CLASS.getName(), list, identityProviderNode, CredentialHandlerResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseLDAPAttributeConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode identityProviderNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.LDAP_STORE_ATTRIBUTE, LDAPStoreAttributeResourceDefinition.NAME.getName(), list, identityProviderNode, LDAPStoreAttributeResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseSupportedTypesConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode identityStoreNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.SUPPORTED_TYPES, null, list, identityStoreNode, SupportedTypesResourceDefinition.INSTANCE.getAttributes());
    }

    private void parseSupportedTypeConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode identityStoreNode) throws XMLStreamException {
        this.parseConfig(reader, ModelElement.SUPPORTED_TYPE, SupportedTypeResourceDefinition.COMMON_CLASS.getName(), list, identityStoreNode, SupportedTypeResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode createSubsystemRoot() {
        ModelNode subsystemAddress = new ModelNode();
        subsystemAddress.add("subsystem", "picketlink");
        subsystemAddress.protect();
        return Util.getEmptyOperation((String)"add", (ModelNode)subsystemAddress);
    }

    private ModelNode parseConfig(XMLExtendedStreamReader reader, ModelElement xmlElement, String key, List<ModelNode> list, ModelNode lastNode, List<SimpleAttributeDefinition> attributes) throws XMLStreamException {
        if (!reader.getLocalName().equals(xmlElement.getName())) {
            return null;
        }
        ModelNode modelNode = Util.getEmptyOperation((String)"add", null);
        for (SimpleAttributeDefinition simpleAttributeDefinition : attributes) {
            simpleAttributeDefinition.parseAndSetParameter(reader.getAttributeValue("", simpleAttributeDefinition.getXmlName()), modelNode, (XMLStreamReader)reader);
        }
        if (key != null) {
            modelNode.get("address").set(lastNode.clone().get("address").add(xmlElement.getName(), modelNode.get(key)));
        } else {
            modelNode.get("address").set(lastNode.clone().get("address").add(xmlElement.getName(), xmlElement.getName()));
        }
        list.add(modelNode);
        return modelNode;
    }
}

