/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth.mapping;

import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.MappingResult;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSGroupMappingProvider
implements MappingProvider<RoleGroup> {
    private Logger log = Logger.getLogger(STSGroupMappingProvider.class);
    private MappingResult<RoleGroup> result;
    private String tokenRoleAttributeName;

    public void init(Map<String, Object> contextMap) {
        Object tokenRoleAttributeObject = contextMap.get("token-role-attribute-name");
        this.tokenRoleAttributeName = tokenRoleAttributeObject != null ? (String)tokenRoleAttributeObject : "role";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initialized with " + contextMap));
        }
    }

    public void performMapping(Map<String, Object> contextMap, RoleGroup Group2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("performMapping with map as " + contextMap));
        }
        if (contextMap == null) {
            throw new IllegalArgumentException("Empty context map. SAML Token must be provided in the context map to extract a Principal");
        }
        Object tokenObject = contextMap.get("org.picketlink.identity.federation.core.wstrust.lm.stsToken");
        if (!(tokenObject instanceof Element)) {
            throw new IllegalArgumentException("Did not find a token " + Element.class.getClass().getName() + " under " + "org.picketlink.identity.federation.core.wstrust.lm.stsToken" + " in the map");
        }
        try {
            Element tokenElement = (Element)tokenObject;
            AssertionType assertion = SAMLUtil.fromElement((Element)tokenElement);
            AttributeStatementType attributeStatement = this.getAttributeStatement(assertion);
            if (attributeStatement != null) {
                SimpleRoleGroup rolesGroup = new SimpleRoleGroup("Roles");
                List attributeList = attributeStatement.getAttributeOrEncryptedAttribute();
                for (Object obj : attributeList) {
                    AttributeType attribute;
                    if (!(obj instanceof AttributeType) || !this.tokenRoleAttributeName.equals((attribute = (AttributeType)obj).getName())) continue;
                    for (Object value : attribute.getAttributeValue()) {
                        rolesGroup.addRole((Role)new SimpleRole((String)value));
                    }
                }
                this.result.setMappedObject((Object)rolesGroup);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Mapped roles to " + rolesGroup));
                }
            }
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setMappingResult(MappingResult<RoleGroup> mappingResult) {
        this.result = mappingResult;
    }

    public boolean supports(Class<?> p) {
        return RoleGroup.class.isAssignableFrom(p);
    }

    private AttributeStatementType getAttributeStatement(AssertionType assertion) {
        List statementList = assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement();
        if (statementList.size() != 0) {
            for (StatementAbstractType statement : statementList) {
                if (!(statement instanceof AttributeStatementType)) continue;
                return (AttributeStatementType)statement;
            }
        }
        return null;
    }
}

