/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.security.KeyPair;
import java.util.List;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Response;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.bindings.tomcat.sp.SPPostFormAuthenticator;
import org.picketlink.identity.federation.bindings.tomcat.sp.SecurityActions;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.w3c.dom.Document;

public class SPPostSignatureFormAuthenticator
extends SPPostFormAuthenticator {
    private static Logger log = Logger.getLogger(SPPostSignatureFormAuthenticator.class);
    private boolean trace = log.isTraceEnabled();
    protected boolean signAssertions = false;

    public SPPostSignatureFormAuthenticator() {
        this.validateSignature = true;
    }

    public boolean isSignAssertions() {
        return this.signAssertions;
    }

    public void setSignAssertions(boolean signAssertions) {
        this.signAssertions = signAssertions;
    }

    public void start() throws LifecycleException {
        super.start();
        this.supportSignatures = true;
        KeyProviderType keyProvider = this.spConfiguration.getKeyProvider();
        if (keyProvider == null) {
            throw new LifecycleException("KeyProvider is null");
        }
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("KeyManager class name is null");
            }
            Class<?> clazz = tcl.loadClass(keyManagerClassName);
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            List authProperties = CoreConfigUtil.getKeyProviderProperties((KeyProviderType)keyProvider);
            this.keyManager.setAuthProperties(authProperties);
            this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
        }
        catch (Exception e) {
            log.error((Object)"Exception reading configuration:", (Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
        if (this.trace) {
            log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
        }
    }

    protected void sendRequestToIDP(String destination, Document samlDocument, String relayState, Response response, boolean willSendRequest) throws ProcessingException, ConfigurationException, IOException {
        SAML2Signature samlSignature = new SAML2Signature();
        KeyPair keypair = this.keyManager.getSigningKeyPair();
        samlSignature.signSAMLDocument(samlDocument, keypair);
        if (this.trace) {
            log.trace((Object)("Sending to IDP:" + DocumentUtil.asString((Document)samlDocument)));
        }
        super.sendRequestToIDP(destination, samlDocument, relayState, response, willSendRequest);
    }
}

