/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static Class<?> loadClass(final Class<?> theClass, final String fqn) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                ClassLoader classLoader = theClass.getClassLoader();
                Class<?> clazz = SecurityActions.loadClass(classLoader, fqn);
                if (clazz == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                    clazz = SecurityActions.loadClass(classLoader, fqn);
                }
                return clazz;
            }
        });
    }

    static Class<?> loadClass(final ClassLoader cl, final String fqn) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return cl.loadClass(fqn);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        });
    }

    static Method getMethod(final Class<?> clazz, final String methodName, final Class<?>[] parameterTypes) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return clazz.getDeclaredMethod(methodName, parameterTypes);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }
}

