/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.idm;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.PropertyQuery;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.config.PicketLinkConfigParser;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.idm.IDMType;
import org.picketlink.config.idm.IdentityConfigurationType;
import org.picketlink.config.idm.StoreConfigurationType;
import org.picketlink.config.idm.resolver.PropertyResolverMapper;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityStoresConfiguration;
import org.picketlink.idm.config.SecurityConfigurationException;

public class XMLBasedIdentityManagerProvider {
    private static final String DEFAULT_IDENTITY_MANAGER_CLASS = "org.picketlink.idm.internal.DefaultIdentityManager";
    private static final String DEFAULT_IDENTITY_STORE_INVOCATION_CONTEXT_FACTORY_CLASS = "org.picketlink.idm.internal.DefaultIdentityStoreInvocationContextFactory";
    private static final String DEFAULT_IDENTITY_CACHE_CLASS = "org.picketlink.idm.DefaultIdentityCache";
    private static final String DEFAULT_ID_GENERATOR_CLASS = "org.picketlink.idm.internal.DefaultIdGenerator";
    private static final String DEFAULT_CREDENTIAL_HANDLER_FACTORY_CLASS = "org.picketlink.idm.credential.internal.DefaultCredentialHandlerFactory";
    public static final ClassLoader IDM_CLASSLOADER = IdentityManager.class.getClassLoader();

    public IdentityManager buildIdentityManager(InputStream inputStream) {
        IDMType idmConfiguration = this.parseIDMType(inputStream);
        return this.buildIdentityManager(idmConfiguration);
    }

    public IDMType parseIDMType(InputStream inputStream) {
        try {
            PicketLinkConfigParser parser = new PicketLinkConfigParser();
            PicketLinkType plType = (PicketLinkType)parser.parse(inputStream);
            return plType.getIdmType();
        }
        catch (ParsingException pe) {
            throw new SecurityConfigurationException("Could not parse picketlink configuration", (Throwable)pe);
        }
    }

    public IdentityManager buildIdentityManager(IDMType idmType) {
        return null;
    }

    protected IdentityConfiguration buildIdentityConfiguration(IdentityConfigurationType identityConfigurationType) {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        ArrayList<IdentityStoreConfiguration> storeConfigs = new ArrayList<IdentityStoreConfiguration>();
        for (StoreConfigurationType storeConfigType : identityConfigurationType.getIdentityStoreConfigurations()) {
            storeConfigs.add(this.buildStoreConfiguration(storeConfigType));
        }
        if (identityConfigurationType.getPartitionStoreConfiguration() != null) {
            IdentityStoreConfiguration partitionStoreConfig = this.buildStoreConfiguration(identityConfigurationType.getPartitionStoreConfiguration());
            storeConfigs.add(partitionStoreConfig);
        }
        builder.stores().readFrom(new IdentityStoresConfiguration(storeConfigs, null));
        return builder.build();
    }

    protected IdentityStoreConfiguration buildStoreConfiguration(StoreConfigurationType storeConfigType) {
        String className = storeConfigType.getClassName();
        if (className == null) {
            throw new SecurityConfigurationException("Classname of all storeConfigurationTypes must be provided!");
        }
        IdentityStoreConfiguration storeConfig = (IdentityStoreConfiguration)XMLBasedIdentityManagerProvider.instantiateComponent(className);
        Class<?> storeConfigClass = storeConfig.getClass();
        Map<String, Object> props = storeConfigType.getAllProperties();
        for (String propertyName : props.keySet()) {
            PropertyQuery propertyQuery = PropertyQueries.createQuery(storeConfigClass);
            propertyQuery.addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{propertyName}));
            Property property = propertyQuery.getWritableSingleResult();
            Object propertyValueFromConfig = props.get(propertyName);
            Object propertyValue = PropertyResolverMapper.getInstance().resolveProperty(propertyValueFromConfig, property.getJavaClass());
            property.setValue((Object)storeConfig, propertyValue);
        }
        return storeConfig;
    }

    public static Object instantiateComponent(String className) {
        try {
            Class clazz = Reflections.classForName((String)className, (ClassLoader[])new ClassLoader[]{IDM_CLASSLOADER});
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new SecurityConfigurationException("Exception during creation of component " + className, (Throwable)e);
        }
    }
}

