/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.idm.parsers;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.AbstractParser;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.idm.IDMType;
import org.picketlink.config.idm.IdentityConfigurationType;
import org.picketlink.config.idm.IdentityStoreInvocationContextFactoryType;
import org.picketlink.config.idm.ObjectType;
import org.picketlink.config.idm.StoreConfigurationType;

public class IDMConfigParser
extends AbstractParser {
    public static final String ROOT_ELEMENT = "PicketLinkIDM";
    public static final String IDENTITY_MANAGER_ELEMENT = "IdentityManager";
    public static final String STORE_FACTORY_ELEMENT = "StoreFactory";
    public static final String IDENTITY_STORE_INVOCATION_CONTEXT_FACTORY_ELEMENT = "IdentityStoreInvocationContextFactory";
    public static final String IDENTITY_CONFIGURATION_ELEMENT = "IdentityConfiguration";
    public static final String CLASS_NAME_ATTRIBUTE = "ClassName";
    public static final String ENTITY_MANAGER_FACTORY_ELEMENT = "EntityManagerFactory";
    public static final String EVENT_BRIDGE_ELEMENT = "EventBridge";
    public static final String CREDENTIAL_HANDLER_FACTORY_ELEMENT = "CredentialHandlerFactory";
    public static final String IDENTITY_CACHE_ELEMENT = "IdentityCache";
    public static final String ID_GENERATOR_ELEMENT = "IdGenerator";
    public static final String IDENTITY_STORE_CONFIGURATION_ELEMENT = "IdentityStoreConfiguration";
    public static final String PARTITION_STORE_CONFIGURATION_ELEMENT = "PartitionStoreConfiguration";
    public static final String PROPERTY_ELEMENT = "Property";
    public static final String PROPERTY_NAME_ATTRIBUTE = "Name";
    public static final String OBJECT_ELEMENT = "Object";

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        EndElement endElement;
        String endElementName;
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)ROOT_ELEMENT);
        IDMType idmType = new IDMType();
        QName classNameAttributeQName = new QName("", CLASS_NAME_ATTRIBUTE);
        while (!(!xmlEventReader.hasNext() || (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) == null || xmlEvent instanceof EndElement && (endElementName = StaxParserUtil.getEndElementName((EndElement)(endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader)))).equals(ROOT_ELEMENT) || (startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader)) == null)) {
            Attribute attribute;
            String elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (elementName.equals(IDENTITY_MANAGER_ELEMENT)) {
                attribute = startElement.getAttributeByName(classNameAttributeQName);
                if (attribute == null) continue;
                idmType.setIdentityManagerClass(StaxParserUtil.getAttributeValue((Attribute)attribute));
                continue;
            }
            if (elementName.equals(STORE_FACTORY_ELEMENT)) {
                attribute = startElement.getAttributeByName(classNameAttributeQName);
                if (attribute == null) continue;
                idmType.setStoreFactoryClass(StaxParserUtil.getAttributeValue((Attribute)attribute));
                continue;
            }
            if (elementName.equals(IDENTITY_STORE_INVOCATION_CONTEXT_FACTORY_ELEMENT)) {
                IdentityStoreInvocationContextFactoryType invContextFactoryType = this.parseIdentityStoreInvocationContextFactoryConfiguration(xmlEventReader, startElement);
                idmType.setIdentityStoreInvocationContextFactory(invContextFactoryType);
                continue;
            }
            if (elementName.equals(IDENTITY_CONFIGURATION_ELEMENT)) {
                IdentityConfigurationType identityConfiguration = this.parseIdentityConfiguration(xmlEventReader, startElement);
                idmType.setIdentityConfigurationType(identityConfiguration);
                continue;
            }
            throw logger.parserUnknownStartElement(elementName, startElement.getLocation());
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (!endElementName.equals(ROOT_ELEMENT)) continue;
                break;
            }
            StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
        }
        return idmType;
    }

    public boolean supports(QName qname) {
        return false;
    }

    protected IdentityStoreInvocationContextFactoryType parseIdentityStoreInvocationContextFactoryConfiguration(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        XMLEvent xmlEvent;
        QName classNameAttributeQName = new QName("", CLASS_NAME_ATTRIBUTE);
        IdentityStoreInvocationContextFactoryType invContextFactoryType = new IdentityStoreInvocationContextFactoryType();
        Attribute attribute = startElement.getAttributeByName(classNameAttributeQName);
        if (attribute != null) {
            invContextFactoryType.setClassName(StaxParserUtil.getAttributeValue((Attribute)attribute));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (!endElementName.equals(IDENTITY_STORE_INVOCATION_CONTEXT_FACTORY_ELEMENT)) continue;
                break;
            }
            startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (elementName.equals(ENTITY_MANAGER_FACTORY_ELEMENT)) {
                attribute = startElement.getAttributeByName(classNameAttributeQName);
                if (attribute == null) continue;
                invContextFactoryType.setEntityManagerFactoryClass(StaxParserUtil.getAttributeValue((Attribute)attribute));
                continue;
            }
            if (elementName.equals(EVENT_BRIDGE_ELEMENT)) {
                attribute = startElement.getAttributeByName(classNameAttributeQName);
                if (attribute == null) continue;
                invContextFactoryType.setEventBridgeClass(StaxParserUtil.getAttributeValue((Attribute)attribute));
                continue;
            }
            if (elementName.equals(CREDENTIAL_HANDLER_FACTORY_ELEMENT)) {
                attribute = startElement.getAttributeByName(classNameAttributeQName);
                if (attribute == null) continue;
                invContextFactoryType.setCredentialHandlerFactoryClass(StaxParserUtil.getAttributeValue((Attribute)attribute));
                continue;
            }
            if (elementName.equals(IDENTITY_CACHE_ELEMENT)) {
                attribute = startElement.getAttributeByName(classNameAttributeQName);
                if (attribute == null) continue;
                invContextFactoryType.setIdentityCacheClass(StaxParserUtil.getAttributeValue((Attribute)attribute));
                continue;
            }
            if (elementName.equals(ID_GENERATOR_ELEMENT)) {
                attribute = startElement.getAttributeByName(classNameAttributeQName);
                if (attribute == null) continue;
                invContextFactoryType.setIdGeneratorClass(StaxParserUtil.getAttributeValue((Attribute)attribute));
                continue;
            }
            throw logger.parserUnknownStartElement(elementName, startElement.getLocation());
        }
        return invContextFactoryType;
    }

    protected IdentityConfigurationType parseIdentityConfiguration(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        XMLEvent xmlEvent;
        IdentityConfigurationType identityConfigurationType = new IdentityConfigurationType();
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (endElementName.equals(IDENTITY_CONFIGURATION_ELEMENT)) break;
                throw logger.parserUnknownEndElement(endElementName);
            }
            startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (elementName.equals(IDENTITY_STORE_CONFIGURATION_ELEMENT)) {
                StoreConfigurationType identityStoreConfiguration = this.parseStoreConfiguration(xmlEventReader, startElement);
                identityConfigurationType.addIdentityStoreConfiguration(identityStoreConfiguration);
                continue;
            }
            if (elementName.equals(PARTITION_STORE_CONFIGURATION_ELEMENT)) {
                StoreConfigurationType partitionStoreConfiguration = this.parseStoreConfiguration(xmlEventReader, startElement);
                identityConfigurationType.setPartitionStoreConfiguration(partitionStoreConfiguration);
                continue;
            }
            throw logger.parserUnknownStartElement(elementName, startElement.getLocation());
        }
        return identityConfigurationType;
    }

    protected StoreConfigurationType parseStoreConfiguration(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        XMLEvent xmlEvent;
        QName classNameAttributeQName = new QName("", CLASS_NAME_ATTRIBUTE);
        String storeFactoryElementName = StaxParserUtil.getStartElementName((StartElement)startElement);
        StoreConfigurationType storeConfigurationType = new StoreConfigurationType();
        Attribute attribute = startElement.getAttributeByName(classNameAttributeQName);
        if (attribute != null) {
            storeConfigurationType.setClassName(StaxParserUtil.getAttributeValue((Attribute)attribute));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (!endElementName.equals(storeFactoryElementName)) continue;
                break;
            }
            startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (elementName.equals(PROPERTY_ELEMENT)) {
                this.parseAndAddProperty(xmlEventReader, startElement, storeConfigurationType);
                continue;
            }
            throw logger.parserUnknownStartElement(elementName, startElement.getLocation());
        }
        return storeConfigurationType;
    }

    protected void parseAndAddProperty(XMLEventReader xmlEventReader, StartElement startElement, StoreConfigurationType storeConfigurationType) throws ParsingException {
        String propertyName = null;
        QName attributeQName = new QName("", PROPERTY_NAME_ATTRIBUTE);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            propertyName = StaxParserUtil.getAttributeValue((Attribute)attribute);
        }
        Object propertyValue = null;
        while (true) {
            EndElement endElement;
            String endElementName;
            XMLEvent xmlEvent;
            if ((xmlEvent = StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader)).isStartElement()) {
                StartElement objectStartElement = xmlEvent.asStartElement();
                if (OBJECT_ELEMENT.equals(StaxParserUtil.getStartElementName((StartElement)objectStartElement))) {
                    propertyValue = this.parseObjectProperty(xmlEventReader, objectStartElement);
                    continue;
                }
                throw logger.parserUnknownStartElement(StaxParserUtil.getStartElementName((StartElement)startElement), startElement.getLocation());
            }
            if (xmlEvent.isCharacters()) {
                Characters chars = xmlEvent.asCharacters();
                propertyValue = chars.getData();
                if (propertyValue != null) {
                    propertyValue = StringUtil.getSystemPropertyAsString((String)((String)propertyValue).trim());
                }
                break;
            }
            if (xmlEvent instanceof EndElement && (endElementName = StaxParserUtil.getEndElementName((EndElement)(endElement = (EndElement)xmlEvent))).equals(PROPERTY_ELEMENT)) break;
        }
        storeConfigurationType.addProperty(propertyName, propertyValue);
    }

    protected ObjectType parseObjectProperty(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        XMLEvent xmlEvent;
        QName classNameAttributeQName = new QName("", CLASS_NAME_ATTRIBUTE);
        String storeFactoryElementName = StaxParserUtil.getStartElementName((StartElement)startElement);
        ObjectType objectType = new ObjectType();
        Attribute attribute = startElement.getAttributeByName(classNameAttributeQName);
        if (attribute != null) {
            objectType.setClassName(StaxParserUtil.getAttributeValue((Attribute)attribute));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (!endElementName.equals(storeFactoryElementName)) continue;
                break;
            }
            startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (elementName.equals(PROPERTY_ELEMENT)) {
                this.parseAndAddProperty(xmlEventReader, startElement, objectType);
                continue;
            }
            throw logger.parserUnknownStartElement(elementName, startElement.getLocation());
        }
        return objectType;
    }
}

