/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.idm.resolver;

import java.util.Map;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.PropertyQuery;
import org.picketlink.config.idm.ObjectType;
import org.picketlink.config.idm.XMLBasedIdentityManagerProvider;
import org.picketlink.config.idm.resolver.BasePropertyResolver;
import org.picketlink.config.idm.resolver.PropertyResolverMapper;
import org.picketlink.idm.config.SecurityConfigurationException;

class ObjectTypeResolver<V>
extends BasePropertyResolver<V> {
    ObjectTypeResolver() {
    }

    @Override
    protected V resolvePropertyFromObjectType(ObjectType objectType) {
        String className = objectType.getClassName();
        if (className == null) {
            throw new SecurityConfigurationException("ClassName must be always configured for all 'Object' types from configuration");
        }
        Object object = XMLBasedIdentityManagerProvider.instantiateComponent(className);
        Class<?> objectClass = object.getClass();
        Map<String, Object> props = objectType.getAllProperties();
        for (String propertyName : props.keySet()) {
            PropertyQuery propertyQuery = PropertyQueries.createQuery(objectClass);
            propertyQuery.addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{propertyName}));
            Property property = propertyQuery.getWritableSingleResult();
            Object propertyValueFromConfig = props.get(propertyName);
            Object propertyValue = PropertyResolverMapper.getInstance().resolveProperty(propertyValueFromConfig, property.getJavaClass());
            property.setValue(object, propertyValue);
        }
        return (V)object;
    }

    @Override
    protected V resolvePropertyFromString(String stringPropertyValue, Class<V> propertyClass) {
        throw new SecurityConfigurationException("Not implemented");
    }
}

