/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import com.gwtplatform.mvp.client.proxy.PlaceRequest;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.shared.viewframework.Columns;
import org.jboss.as.console.client.widgets.tables.TextLinkCell;
import org.jboss.ballroom.client.widgets.forms.FormAdapter;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.shared.subsys.model.Federation;
import org.picketlink.as.console.client.ui.federation.AbstractModelElementTable;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;

public class FederationTable
extends AbstractModelElementTable<Federation> {
    private final FederationPresenter presenter;
    private final PicketLinkUIConstants uiConstants;
    private Federation selectedFederation;
    private FormAdapter<Federation> federationDetails;

    public FederationTable(FederationPresenter presenter, FormAdapter<Federation> federationDetails, PicketLinkUIConstants uiConstants) {
        this.presenter = presenter;
        this.federationDetails = federationDetails;
        this.uiConstants = uiConstants;
    }

    @Override
    protected Object doGetKey(Federation item) {
        return item.getName();
    }

    @Override
    protected void doAddConlumns(CellTable table) {
        Column<Federation, Federation> option = new Column<Federation, Federation>((Cell)new TextLinkCell(Console.CONSTANTS.common_label_view(), (ActionCell.Delegate)new ActionCell.Delegate<Federation>(){

            public void execute(Federation selection) {
                FederationTable.this.presenter.getPlaceManager().revealPlace(new PlaceRequest("picletlink-federation").with("name", selection.getName()));
            }
        })){

            public Federation getValue(Federation domain) {
                return domain;
            }
        };
        table.addColumn((Column)new Columns.NameColumn(), this.uiConstants.common_label_alias());
        table.addColumn((Column)option, "Option");
    }

    public Federation getSelectedFederation() {
        return this.selectedFederation;
    }

    public void addSelectionChangeHandler() {
        SingleSelectionModel selectionModel = new SingleSelectionModel();
        this.getCellTable().setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                Federation selectedObject = (Federation)((SingleSelectionModel)event.getSource()).getSelectedObject();
                FederationTable.this.selectedFederation = selectedObject;
                FederationTable.this.federationDetails.edit((Object)selectedObject);
                FederationTable.this.presenter.updateFederationSelection(selectedObject);
            }
        });
    }
}

