/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.sp;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.widgets.ContentDescription;
import org.jboss.ballroom.client.widgets.ContentHeaderLabel;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.jboss.ballroom.client.widgets.tools.ToolButton;
import org.jboss.ballroom.client.widgets.tools.ToolStrip;
import org.jboss.ballroom.client.widgets.window.Feedback;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.i18n.PicketLinkUIMessages;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandler;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandlerParameter;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandlerWrapper;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderWrapper;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderHandlerParameterTable;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderHandlerTable;

public class ServiceProviderHandlersTabEditor {
    private Form<ServiceProviderHandler> handlerForm;
    private ServiceProviderHandlerTable handlerTable;
    private Form<ServiceProviderHandlerParameter> handlerParameterForm;
    private ServiceProviderHandlerParameterTable handlerParameterTable;
    private FederationPresenter presenter;
    private ServiceProviderWrapper serviceProvider;
    private ToolButton removeHandlerBtn;
    private ToolButton addHandlerBtn;
    private ToolButton removeHandlerParameterBtn;
    private ToolButton addHandlerParameterBtn;
    private PicketLinkUIConstants uiConstants;
    private PicketLinkUIMessages uiMessages;

    public ServiceProviderHandlersTabEditor(FederationPresenter presenter, PicketLinkUIConstants uiConstants, PicketLinkUIMessages uiMessages) {
        this.presenter = presenter;
        this.uiConstants = uiConstants;
        this.uiMessages = uiMessages;
    }

    public Widget asWidget() {
        VerticalPanel trustDomainsHeader = new VerticalPanel();
        trustDomainsHeader.setStyleName("fill-layout-width");
        this.addHandlerForm(trustDomainsHeader);
        this.addHandlerActions(trustDomainsHeader);
        this.addHandlerTable(trustDomainsHeader);
        trustDomainsHeader.add((Widget)new ContentHeaderLabel("Handler Parameters"));
        this.addHandlerParameterForm(trustDomainsHeader);
        this.addHandlerParameterActions(trustDomainsHeader);
        trustDomainsHeader.add(this.getHandlerParameterTable().asWidget());
        return trustDomainsHeader;
    }

    private void addHandlerTable(VerticalPanel detailPanel) {
        detailPanel.add(this.getHandlerTable().asWidget());
    }

    private void addHandlerActions(VerticalPanel trustDomainsHeader) {
        ToolStrip trustDomainTools = new ToolStrip();
        this.addHandlerBtn = new ToolButton(Console.CONSTANTS.common_label_add());
        this.addHandlerBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ServiceProviderHandlersTabEditor.this.serviceProvider == null) {
                    Window.alert((String)ServiceProviderHandlersTabEditor.this.uiMessages.identityProviderNotConfigured());
                } else {
                    ServiceProviderHandler newTrustedDomain = (ServiceProviderHandler)ServiceProviderHandlersTabEditor.this.handlerForm.getUpdatedEntity();
                    if (newTrustedDomain != null && !newTrustedDomain.getClassName().trim().isEmpty()) {
                        ServiceProviderHandlersTabEditor.this.presenter.getFederationManager().onCreateServiceProviderHandler(ServiceProviderHandlersTabEditor.this.serviceProvider.getServiceProvider(), newTrustedDomain);
                        ServiceProviderHandlersTabEditor.this.getHandlerTable().getDataProvider().getList().add(newTrustedDomain);
                    } else {
                        Window.alert((String)ServiceProviderHandlersTabEditor.this.uiMessages.invalidTrustedDomain());
                    }
                    ServiceProviderHandlersTabEditor.this.handlerForm.clearValues();
                }
            }
        });
        trustDomainTools.addToolButtonRight(this.addHandlerBtn);
        this.removeHandlerBtn = new ToolButton(Console.CONSTANTS.common_label_delete());
        this.removeHandlerBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final ServiceProviderHandler removedTrustedDomain = ServiceProviderHandlersTabEditor.this.getHandlerTable().getSelectedHandler();
                Feedback.confirm((String)Console.MESSAGES.deleteTitle(ServiceProviderHandlersTabEditor.this.uiConstants.common_label_trustDomain()), (String)Console.MESSAGES.deleteConfirm(removedTrustedDomain.getClassName()), (Feedback.ConfirmationHandler)new Feedback.ConfirmationHandler(){

                    public void onConfirmation(boolean isConfirmed) {
                        if (isConfirmed) {
                            ServiceProviderHandlersTabEditor.this.presenter.getFederationManager().onRemoveServiceProviderHandler(ServiceProviderHandlersTabEditor.this.serviceProvider.getServiceProvider(), removedTrustedDomain);
                            ServiceProviderHandlersTabEditor.this.getHandlerTable().getDataProvider().getList().remove(removedTrustedDomain);
                            ServiceProviderHandlersTabEditor.this.getHandlerParameterTable().getDataProvider().getList().clear();
                        }
                    }
                });
                ServiceProviderHandlersTabEditor.this.handlerForm.clearValues();
            }
        });
        trustDomainTools.addToolButtonRight(this.removeHandlerBtn);
        trustDomainTools.setStyleName("fill-layout-width");
        trustDomainsHeader.add((Widget)trustDomainTools);
        trustDomainsHeader.add((Widget)new ContentDescription(""));
    }

    private void addHandlerParameterActions(VerticalPanel trustDomainsHeader) {
        ToolStrip trustDomainTools = new ToolStrip();
        this.addHandlerParameterBtn = new ToolButton(Console.CONSTANTS.common_label_add());
        this.addHandlerParameterBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ServiceProviderHandlersTabEditor.this.getHandlerTable().getSelectedHandler() == null) {
                    Window.alert((String)"Please, selecte a handler first.");
                } else {
                    ServiceProviderHandlerParameter newHandlerParameter = (ServiceProviderHandlerParameter)ServiceProviderHandlersTabEditor.this.handlerParameterForm.getUpdatedEntity();
                    if (newHandlerParameter != null && !newHandlerParameter.getName().trim().isEmpty()) {
                        ServiceProviderHandlersTabEditor.this.presenter.getFederationManager().onCreateServiceProviderHandlerParameter(ServiceProviderHandlersTabEditor.this.serviceProvider.getServiceProvider(), ServiceProviderHandlersTabEditor.this.getHandlerTable().getSelectedHandler(), newHandlerParameter);
                        ServiceProviderHandlersTabEditor.this.getHandlerParameterTable().getDataProvider().getList().add(newHandlerParameter);
                    } else {
                        Window.alert((String)"Invalid Handler Parameter");
                    }
                    ServiceProviderHandlersTabEditor.this.handlerParameterForm.clearValues();
                }
            }
        });
        trustDomainTools.addToolButtonRight(this.addHandlerParameterBtn);
        this.removeHandlerParameterBtn = new ToolButton(Console.CONSTANTS.common_label_delete());
        this.removeHandlerParameterBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final ServiceProviderHandlerParameter removedHandlerParameter = ServiceProviderHandlersTabEditor.this.getHandlerParameterTable().getSelectedHandlerParameter();
                Feedback.confirm((String)Console.MESSAGES.deleteTitle("Handler Parameter"), (String)Console.MESSAGES.deleteConfirm(removedHandlerParameter.getName()), (Feedback.ConfirmationHandler)new Feedback.ConfirmationHandler(){

                    public void onConfirmation(boolean isConfirmed) {
                        if (isConfirmed) {
                            ServiceProviderHandlersTabEditor.this.presenter.getFederationManager().onRemoveServiceProviderHandlerParameter(ServiceProviderHandlersTabEditor.this.serviceProvider.getServiceProvider(), ServiceProviderHandlersTabEditor.this.getHandlerTable().getSelectedHandler(), removedHandlerParameter);
                            ServiceProviderHandlersTabEditor.this.getHandlerParameterTable().getDataProvider().getList().remove(removedHandlerParameter);
                        }
                    }
                });
                ServiceProviderHandlersTabEditor.this.handlerParameterForm.clearValues();
            }
        });
        trustDomainTools.addToolButtonRight(this.removeHandlerParameterBtn);
        trustDomainTools.setStyleName("fill-layout-width");
        trustDomainsHeader.add((Widget)trustDomainTools);
        trustDomainsHeader.add((Widget)new ContentDescription(""));
    }

    private void addHandlerForm(VerticalPanel trustDomainsHeader) {
        this.handlerForm = new Form(ServiceProviderHandler.class);
        TextBoxItem domainName = new TextBoxItem("className", "Class Name");
        domainName.setRequired(true);
        this.handlerForm.setFields(new FormItem[]{domainName});
        trustDomainsHeader.add(this.handlerForm.asWidget());
    }

    private void addHandlerParameterForm(VerticalPanel trustDomainsHeader) {
        this.handlerParameterForm = new Form(ServiceProviderHandlerParameter.class);
        TextBoxItem handlerName = new TextBoxItem("name", "Name");
        handlerName.setRequired(true);
        TextBoxItem handlerValue = new TextBoxItem("value", "Value");
        handlerValue.setRequired(true);
        this.handlerParameterForm.setFields(new FormItem[]{handlerName, handlerValue});
        trustDomainsHeader.add(this.handlerParameterForm.asWidget());
    }

    public ServiceProviderHandlerTable getHandlerTable() {
        if (this.handlerTable == null) {
            this.handlerTable = new ServiceProviderHandlerTable();
            this.handlerTable.setParametersTable(this.getHandlerParameterTable());
            this.handlerTable.setPresenter(this.presenter);
            this.handlerTable.setHandlersTabEditor(this);
        }
        return this.handlerTable;
    }

    public ServiceProviderHandlerParameterTable getHandlerParameterTable() {
        if (this.handlerParameterTable == null) {
            this.handlerParameterTable = new ServiceProviderHandlerParameterTable();
        }
        return this.handlerParameterTable;
    }

    private void showRestartDialog() {
        if (Window.confirm((String)"Changes would be applied after a restart. Do you want to do it now ?")) {
            this.presenter.getDeploymentManager().restartServiceProvider(this.serviceProvider.getServiceProvider());
        }
    }

    public void setServiceProvider(ServiceProviderWrapper selectedServiceProvider) {
        if (selectedServiceProvider == null) {
            this.handlerForm.setEnabled(false);
            this.addHandlerBtn.setEnabled(false);
            this.removeHandlerBtn.setEnabled(false);
        } else {
            this.handlerForm.setEnabled(true);
            this.addHandlerBtn.setEnabled(true);
            this.removeHandlerBtn.setEnabled(true);
        }
        this.serviceProvider = selectedServiceProvider;
        this.getHandlerTable().setSelectedServiceProvider(this.serviceProvider);
    }

    public void doUpdateSelection(ServiceProviderHandler selectedHandler) {
        List<ServiceProviderHandlerWrapper> handlers = this.serviceProvider.getHandlers();
        ArrayList<ServiceProviderHandlerParameter> parameters = new ArrayList<ServiceProviderHandlerParameter>();
        for (ServiceProviderHandlerWrapper handlerWrapper : handlers) {
            if (!handlerWrapper.getHandler().getClassName().equals(selectedHandler.getClassName())) continue;
            for (ServiceProviderHandlerParameter serviceProviderHandlerParameter : handlerWrapper.getParameters()) {
                parameters.add(serviceProviderHandlerParameter);
            }
        }
        this.getHandlerParameterTable().getDataProvider().setList(parameters);
    }
}

