/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.jboss.as.console.client.widgets.forms.FormToolStrip;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.FormValidation;
import org.jboss.ballroom.client.widgets.window.DialogueOptions;
import org.jboss.ballroom.client.widgets.window.WindowContentBuilder;
import org.picketlink.as.console.client.shared.subsys.model.GenericFederationEntity;
import org.picketlink.as.console.client.ui.federation.AbstractFederationDetailEditor;
import org.picketlink.as.console.client.ui.federation.AsyncHelpText;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.Wizard;

public abstract class AbstractFederationWizard<T extends GenericFederationEntity>
implements Wizard<T> {
    private final AbstractFederationDetailEditor<T> editor;
    private final Class<T> entityClass;
    private Form<T> form;
    private final FederationPresenter presenter;
    private final String type;
    private final String[] attributesNames;
    private boolean isDialogue = false;

    public AbstractFederationWizard(AbstractFederationDetailEditor<T> editor, Class<T> cls, FederationPresenter presenter, String type, String ... attributeNames) {
        this.editor = editor;
        this.entityClass = cls;
        this.presenter = presenter;
        this.type = type;
        this.attributesNames = attributeNames;
    }

    @Override
    public Wizard<T> setIsDialogue(boolean b) {
        this.isDialogue = b;
        return this;
    }

    @Override
    public void clearValues() {
        this.form.clearValues();
    }

    @Override
    public Widget asWidget() {
        VerticalPanel layout = new VerticalPanel();
        layout.setStyleName(this.isDialogue ? "window-content" : "fill-layout");
        this.form = new Form(this.entityClass);
        this.form.setFields(this.doGetCustomFields());
        final Command saveCmd = new Command(){

            public void execute() {
                FormValidation validation = AbstractFederationWizard.this.form.validate();
                if (!validation.hasErrors()) {
                    if (!AbstractFederationWizard.this.isDialogue) {
                        GenericFederationEntity original = (GenericFederationEntity)AbstractFederationWizard.this.form.getEditedEntity();
                        GenericFederationEntity edited = (GenericFederationEntity)AbstractFederationWizard.this.form.getUpdatedEntity();
                        original.setName(edited.getName());
                        AbstractFederationWizard.this.editor.doUpdate(edited, AbstractFederationWizard.this.form.getChangedValues());
                        AbstractFederationWizard.this.form.edit((Object)edited);
                    } else {
                        GenericFederationEntity data = (GenericFederationEntity)AbstractFederationWizard.this.form.getUpdatedEntity();
                        AbstractFederationWizard.this.editor.doSaveWizard(data);
                    }
                    AbstractFederationWizard.this.presenter.loadDeployments();
                    AbstractFederationWizard.this.editor.closeWizard();
                }
            }
        };
        if (!this.isDialogue) {
            FormToolStrip toolStrip = new FormToolStrip(this.form, new FormToolStrip.FormCallback<T>(){

                public void onSave(Map<String, Object> changeset) {
                    saveCmd.execute();
                }

                public void onDelete(T entity) {
                    AbstractFederationWizard.this.editor.closeWizard();
                    AbstractFederationWizard.this.presenter.loadDeployments();
                }
            });
            toolStrip.providesDeleteOp(false);
            layout.add(toolStrip.asWidget());
            this.form.setEnabled(false);
            this.form.setNumColumns(2);
        }
        new AsyncHelpText(this.type, this.attributesNames, this.presenter, layout, this.isDialogue);
        layout.add(this.form.asWidget());
        DialogueOptions options = new DialogueOptions(new ClickHandler(){

            public void onClick(ClickEvent event) {
                saveCmd.execute();
            }
        }, new ClickHandler(){

            public void onClick(ClickEvent event) {
                AbstractFederationWizard.this.form.clearValues();
                AbstractFederationWizard.this.editor.closeWizard();
            }
        });
        return this.isDialogue ? new WindowContentBuilder((Widget)layout, (Widget)options).build() : layout;
    }

    protected FormItem<?>[] doGetCustomFields() {
        return new FormItem[0];
    }

    @Override
    public void edit(T object) {
        this.form.edit(object);
    }

    public AbstractFederationDetailEditor<T> getEditor() {
        return this.editor;
    }

    public boolean isDialogue() {
        return this.isDialogue;
    }

    protected FederationPresenter getPresenter() {
        return this.presenter;
    }
}

