/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.widgets.ContentDescription;
import org.jboss.ballroom.client.widgets.ContentHeaderLabel;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.jboss.ballroom.client.widgets.tools.ToolButton;
import org.jboss.ballroom.client.widgets.tools.ToolStrip;
import org.jboss.ballroom.client.widgets.window.Feedback;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.i18n.PicketLinkUIMessages;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProvider;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandler;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandlerParameter;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderHandlerParameterTable;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderHandlerTable;

public class IdentityProviderHandlersTabEditor {
    private Form<IdentityProviderHandler> handlerForm;
    private IdentityProviderHandlerTable handlerTable;
    private Form<IdentityProviderHandlerParameter> handlerParameterForm;
    private IdentityProviderHandlerParameterTable handlerParameterTable;
    private FederationPresenter presenter;
    private IdentityProvider identityProvider;
    private ToolButton removeHandlerBtn;
    private ToolButton addHandlerBtn;
    private ToolButton removeHandlerParameterBtn;
    private ToolButton addHandlerParameterBtn;
    private PicketLinkUIConstants uiConstants;
    private PicketLinkUIMessages uiMessages;

    public IdentityProviderHandlersTabEditor(FederationPresenter presenter, PicketLinkUIConstants uiConstants, PicketLinkUIMessages uiMessages) {
        this.presenter = presenter;
        this.uiConstants = uiConstants;
        this.uiMessages = uiMessages;
    }

    public Widget asWidget() {
        VerticalPanel trustDomainsHeader = new VerticalPanel();
        trustDomainsHeader.setStyleName("fill-layout-width");
        this.addHandlerForm(trustDomainsHeader);
        this.addHandlerActions(trustDomainsHeader);
        this.addHandlerTable(trustDomainsHeader);
        trustDomainsHeader.add((Widget)new ContentHeaderLabel("Handler Parameters"));
        this.addHandlerParameterForm(trustDomainsHeader);
        this.addHandlerParameterActions(trustDomainsHeader);
        trustDomainsHeader.add(this.getHandlerParameterTable().asWidget());
        return trustDomainsHeader;
    }

    private void addHandlerTable(VerticalPanel detailPanel) {
        detailPanel.add(this.getHandlerTable().asWidget());
    }

    private void addHandlerActions(VerticalPanel trustDomainsHeader) {
        ToolStrip trustDomainTools = new ToolStrip();
        this.addHandlerBtn = new ToolButton(Console.CONSTANTS.common_label_add());
        this.addHandlerBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (IdentityProviderHandlersTabEditor.this.identityProvider == null) {
                    Window.alert((String)IdentityProviderHandlersTabEditor.this.uiMessages.identityProviderNotConfigured());
                } else {
                    IdentityProviderHandler newTrustedDomain = (IdentityProviderHandler)IdentityProviderHandlersTabEditor.this.handlerForm.getUpdatedEntity();
                    if (newTrustedDomain != null && !newTrustedDomain.getClassName().trim().isEmpty()) {
                        IdentityProviderHandlersTabEditor.this.presenter.getFederationManager().onCreateIdentityProviderHandler(IdentityProviderHandlersTabEditor.this.identityProvider, newTrustedDomain);
                        IdentityProviderHandlersTabEditor.this.getHandlerTable().getDataProvider().getList().add(newTrustedDomain);
                    } else {
                        Window.alert((String)IdentityProviderHandlersTabEditor.this.uiMessages.invalidTrustedDomain());
                    }
                    IdentityProviderHandlersTabEditor.this.handlerForm.clearValues();
                }
            }
        });
        trustDomainTools.addToolButtonRight(this.addHandlerBtn);
        this.removeHandlerBtn = new ToolButton(Console.CONSTANTS.common_label_delete());
        this.removeHandlerBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final IdentityProviderHandler removedTrustedDomain = IdentityProviderHandlersTabEditor.this.getHandlerTable().getSelectedHandler();
                Feedback.confirm((String)Console.MESSAGES.deleteTitle(IdentityProviderHandlersTabEditor.this.uiConstants.common_label_trustDomain()), (String)Console.MESSAGES.deleteConfirm(removedTrustedDomain.getClassName()), (Feedback.ConfirmationHandler)new Feedback.ConfirmationHandler(){

                    public void onConfirmation(boolean isConfirmed) {
                        if (isConfirmed) {
                            IdentityProviderHandlersTabEditor.this.presenter.getFederationManager().onRemoveIdentityProviderHandler(IdentityProviderHandlersTabEditor.this.identityProvider, removedTrustedDomain);
                            IdentityProviderHandlersTabEditor.this.getHandlerTable().getDataProvider().getList().remove(removedTrustedDomain);
                            IdentityProviderHandlersTabEditor.this.getHandlerParameterTable().getDataProvider().getList().clear();
                        }
                    }
                });
                IdentityProviderHandlersTabEditor.this.handlerForm.clearValues();
            }
        });
        trustDomainTools.addToolButtonRight(this.removeHandlerBtn);
        trustDomainTools.setStyleName("fill-layout-width");
        trustDomainsHeader.add((Widget)trustDomainTools);
        trustDomainsHeader.add((Widget)new ContentDescription(""));
    }

    private void addHandlerParameterActions(VerticalPanel trustDomainsHeader) {
        ToolStrip trustDomainTools = new ToolStrip();
        this.addHandlerParameterBtn = new ToolButton(Console.CONSTANTS.common_label_add());
        this.addHandlerParameterBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (IdentityProviderHandlersTabEditor.this.getHandlerTable().getSelectedHandler() == null) {
                    Window.alert((String)"Please, selecte a handler first.");
                } else {
                    IdentityProviderHandlerParameter newHandlerParameter = (IdentityProviderHandlerParameter)IdentityProviderHandlersTabEditor.this.handlerParameterForm.getUpdatedEntity();
                    if (newHandlerParameter != null && !newHandlerParameter.getName().trim().isEmpty()) {
                        IdentityProviderHandlersTabEditor.this.presenter.getFederationManager().onCreateIdentityProviderHandlerParameter(IdentityProviderHandlersTabEditor.this.identityProvider, IdentityProviderHandlersTabEditor.this.getHandlerTable().getSelectedHandler(), newHandlerParameter);
                        IdentityProviderHandlersTabEditor.this.getHandlerParameterTable().getDataProvider().getList().add(newHandlerParameter);
                    } else {
                        Window.alert((String)"Invalid Handler Parameter");
                    }
                    IdentityProviderHandlersTabEditor.this.handlerParameterForm.clearValues();
                }
            }
        });
        trustDomainTools.addToolButtonRight(this.addHandlerParameterBtn);
        this.removeHandlerParameterBtn = new ToolButton(Console.CONSTANTS.common_label_delete());
        this.removeHandlerParameterBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final IdentityProviderHandlerParameter removedHandlerParameter = IdentityProviderHandlersTabEditor.this.getHandlerParameterTable().getSelectedHandlerParameter();
                Feedback.confirm((String)Console.MESSAGES.deleteTitle("Handler Parameter"), (String)Console.MESSAGES.deleteConfirm(removedHandlerParameter.getName()), (Feedback.ConfirmationHandler)new Feedback.ConfirmationHandler(){

                    public void onConfirmation(boolean isConfirmed) {
                        if (isConfirmed) {
                            IdentityProviderHandlersTabEditor.this.presenter.getFederationManager().onRemoveIdentityProviderHandlerParameter(IdentityProviderHandlersTabEditor.this.identityProvider, IdentityProviderHandlersTabEditor.this.getHandlerTable().getSelectedHandler(), removedHandlerParameter);
                            IdentityProviderHandlersTabEditor.this.getHandlerParameterTable().getDataProvider().getList().remove(removedHandlerParameter);
                        }
                    }
                });
                IdentityProviderHandlersTabEditor.this.handlerParameterForm.clearValues();
            }
        });
        trustDomainTools.addToolButtonRight(this.removeHandlerParameterBtn);
        trustDomainTools.setStyleName("fill-layout-width");
        trustDomainsHeader.add((Widget)trustDomainTools);
        trustDomainsHeader.add((Widget)new ContentDescription(""));
    }

    private void addHandlerForm(VerticalPanel trustDomainsHeader) {
        this.handlerForm = new Form(IdentityProviderHandler.class);
        TextBoxItem domainName = new TextBoxItem("className", "Class Name");
        domainName.setRequired(true);
        this.handlerForm.setFields(new FormItem[]{domainName});
        trustDomainsHeader.add(this.handlerForm.asWidget());
    }

    private void addHandlerParameterForm(VerticalPanel trustDomainsHeader) {
        this.handlerParameterForm = new Form(IdentityProviderHandlerParameter.class);
        TextBoxItem handlerName = new TextBoxItem("name", "Name");
        handlerName.setRequired(true);
        TextBoxItem handlerValue = new TextBoxItem("value", "Value");
        handlerValue.setRequired(true);
        this.handlerParameterForm.setFields(new FormItem[]{handlerName, handlerValue});
        trustDomainsHeader.add(this.handlerParameterForm.asWidget());
    }

    public IdentityProviderHandlerTable getHandlerTable() {
        if (this.handlerTable == null) {
            this.handlerTable = new IdentityProviderHandlerTable();
            this.handlerTable.setParametersTable(this.getHandlerParameterTable());
            this.handlerTable.setPresenter(this.presenter);
        }
        return this.handlerTable;
    }

    public IdentityProviderHandlerParameterTable getHandlerParameterTable() {
        if (this.handlerParameterTable == null) {
            this.handlerParameterTable = new IdentityProviderHandlerParameterTable();
        }
        return this.handlerParameterTable;
    }

    private void showRestartDialog() {
        if (Window.confirm((String)"Changes would be applied after a restart. Do you want to do it now ?")) {
            this.presenter.getDeploymentManager().restartIdentityProvider(this.identityProvider);
        }
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        if (identityProvider == null || identityProvider.isExternal()) {
            this.handlerForm.setEnabled(false);
            this.addHandlerBtn.setEnabled(false);
            this.removeHandlerBtn.setEnabled(false);
        } else {
            this.handlerForm.setEnabled(true);
            this.addHandlerBtn.setEnabled(true);
            this.removeHandlerBtn.setEnabled(true);
        }
        this.identityProvider = identityProvider;
    }
}

