/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.widgets.ContentDescription;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.jboss.ballroom.client.widgets.tools.ToolButton;
import org.jboss.ballroom.client.widgets.tools.ToolStrip;
import org.jboss.ballroom.client.widgets.window.Feedback;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.i18n.PicketLinkUIMessages;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProvider;
import org.picketlink.as.console.client.shared.subsys.model.TrustDomain;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.idp.TrustDomainTable;

public class TrustedDomainTabEditor {
    private Form<TrustDomain> trustDomainForm;
    private TrustDomainTable trustDomainTable;
    private FederationPresenter presenter;
    private IdentityProvider identityProvider;
    private ToolButton removeTrustedDomainBtn;
    private ToolButton addTrustedDomainBtn;
    private PicketLinkUIConstants uiConstants;
    private PicketLinkUIMessages uiMessages;

    public TrustedDomainTabEditor(FederationPresenter presenter, PicketLinkUIConstants uiConstants, PicketLinkUIMessages uiMessages) {
        this.presenter = presenter;
        this.uiConstants = uiConstants;
        this.uiMessages = uiMessages;
    }

    public Widget asWidget() {
        VerticalPanel trustDomainsHeader = new VerticalPanel();
        trustDomainsHeader.setStyleName("fill-layout-width");
        this.addTrustDomainForm(trustDomainsHeader);
        this.addTrustDomainActions(trustDomainsHeader);
        this.addTrustDomainTable(trustDomainsHeader);
        return trustDomainsHeader;
    }

    private void addTrustDomainTable(VerticalPanel detailPanel) {
        detailPanel.add(this.getTrustDomainTable().asWidget());
    }

    private void addTrustDomainActions(VerticalPanel trustDomainsHeader) {
        ToolStrip trustDomainTools = new ToolStrip();
        this.addTrustedDomainBtn = new ToolButton(Console.CONSTANTS.common_label_add());
        this.addTrustedDomainBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (TrustedDomainTabEditor.this.identityProvider == null) {
                    Window.alert((String)TrustedDomainTabEditor.this.uiMessages.identityProviderNotConfigured());
                } else {
                    TrustDomain newTrustedDomain = (TrustDomain)TrustedDomainTabEditor.this.trustDomainForm.getUpdatedEntity();
                    if (newTrustedDomain.getCertAlias().trim().isEmpty()) {
                        newTrustedDomain.setCertAlias(null);
                    }
                    if (newTrustedDomain != null && !newTrustedDomain.getName().trim().isEmpty()) {
                        TrustedDomainTabEditor.this.presenter.getFederationManager().onCreateTrustDomain(TrustedDomainTabEditor.this.identityProvider, newTrustedDomain);
                        TrustedDomainTabEditor.this.getTrustDomainTable().getDataProvider().getList().add(newTrustedDomain);
                    } else {
                        Window.alert((String)TrustedDomainTabEditor.this.uiMessages.invalidTrustedDomain());
                    }
                    TrustedDomainTabEditor.this.trustDomainForm.clearValues();
                }
            }
        });
        trustDomainTools.addToolButtonRight(this.addTrustedDomainBtn);
        this.removeTrustedDomainBtn = new ToolButton(Console.CONSTANTS.common_label_delete());
        this.removeTrustedDomainBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final TrustDomain removedTrustedDomain = TrustedDomainTabEditor.this.getTrustDomainTable().getSelectedTrustedDomain();
                Feedback.confirm((String)Console.MESSAGES.deleteTitle(TrustedDomainTabEditor.this.uiConstants.common_label_trustDomain()), (String)Console.MESSAGES.deleteConfirm(removedTrustedDomain.getName()), (Feedback.ConfirmationHandler)new Feedback.ConfirmationHandler(){

                    public void onConfirmation(boolean isConfirmed) {
                        if (isConfirmed) {
                            TrustedDomainTabEditor.this.presenter.getFederationManager().onRemoveTrustDomain(TrustedDomainTabEditor.this.identityProvider, removedTrustedDomain);
                            TrustedDomainTabEditor.this.getTrustDomainTable().getDataProvider().getList().remove(removedTrustedDomain);
                        }
                    }
                });
                TrustedDomainTabEditor.this.trustDomainForm.clearValues();
            }
        });
        trustDomainTools.addToolButtonRight(this.removeTrustedDomainBtn);
        trustDomainTools.setStyleName("fill-layout-width");
        trustDomainsHeader.add((Widget)trustDomainTools);
        trustDomainsHeader.add((Widget)new ContentDescription(""));
    }

    private void addTrustDomainForm(VerticalPanel trustDomainsHeader) {
        this.trustDomainForm = new Form(TrustDomain.class);
        TextBoxItem domainName = new TextBoxItem("name", this.uiConstants.common_label_domainName());
        domainName.setRequired(true);
        TextBoxItem certAliasName = new TextBoxItem("certAlias", "Certificate Alias");
        certAliasName.setRequired(false);
        this.trustDomainForm.setFields(new FormItem[]{domainName, certAliasName});
        trustDomainsHeader.add(this.trustDomainForm.asWidget());
    }

    public TrustDomainTable getTrustDomainTable() {
        if (this.trustDomainTable == null) {
            this.trustDomainTable = new TrustDomainTable();
        }
        return this.trustDomainTable;
    }

    private void showRestartDialog() {
        if (Window.confirm((String)"Changes would be applied after a restart. Do you want to do it now ?")) {
            this.presenter.getDeploymentManager().restartIdentityProvider(this.identityProvider);
        }
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        if (identityProvider == null || identityProvider.isExternal()) {
            this.trustDomainForm.setEnabled(false);
            this.addTrustedDomainBtn.setEnabled(false);
            this.removeTrustedDomainBtn.setEnabled(false);
        } else {
            this.trustDomainForm.setEnabled(true);
            this.addTrustedDomainBtn.setEnabled(true);
            this.removeTrustedDomainBtn.setEnabled(true);
        }
        this.identityProvider = identityProvider;
    }
}

