/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.sts;

import java.util.Map;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.shared.subsys.model.FederationWrapper;
import org.picketlink.as.console.client.shared.subsys.model.SecurityTokenService;
import org.picketlink.as.console.client.ui.federation.AbstractFederationDetailEditor;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.Wizard;
import org.picketlink.as.console.client.ui.federation.sts.NewSecurityTokenServiceWizard;
import org.picketlink.as.console.client.ui.federation.sts.SecurityTokenServiceTable;

public class SecurityTokenServiceEditor
extends AbstractFederationDetailEditor<SecurityTokenService> {
    private PicketLinkUIConstants uiConstants;

    public SecurityTokenServiceEditor(FederationPresenter presenter, PicketLinkUIConstants uiConstants) {
        super(presenter, new SecurityTokenServiceTable(presenter), SecurityTokenService.class);
        this.uiConstants = uiConstants;
    }

    @Override
    public String doGetEntityName() {
        return this.uiConstants.common_label_securityTokenService();
    }

    @Override
    protected String doGetDescription() {
        return this.uiConstants.subsys_picketlink_security_token_service_desc();
    }

    @Override
    public String doGetTableSectionName() {
        return "Security Token Services";
    }

    @Override
    protected boolean doInsert(SecurityTokenService serviceProvider) {
        this.getPresenter().getFederationManager().onCreateSecurityTokenService(serviceProvider);
        this.getPresenter().getDeploymentManager().restartSecurityTokenService(serviceProvider);
        return true;
    }

    @Override
    protected void doDelete(SecurityTokenService securityTokenService) {
        this.getPresenter().getFederationManager().onRemoveSecurityTokenService(securityTokenService);
    }

    @Override
    public void doUpdate(SecurityTokenService securityTokenService, Map<String, Object> changedValues) {
        this.getPresenter().getFederationManager().onUpdateSecurityTokenService(securityTokenService, changedValues);
        this.getPresenter().getDeploymentManager().restartSecurityTokenService(securityTokenService);
    }

    @Override
    public Wizard<SecurityTokenService> doCreateWizard() {
        return new NewSecurityTokenServiceWizard<SecurityTokenService>(this, this.getEntityClass(), this.getPresenter(), "security-token-service", this.uiConstants);
    }

    public void updateSecurityTokenServices(FederationWrapper federation) {
        this.setData(federation, federation.getSecurityTokenServices());
    }
}

