/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import org.jboss.as.console.client.Console;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandler;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandlerParameter;
import org.picketlink.as.console.client.ui.federation.AbstractWizard;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderHandlerTable;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderHandlersTabEditor;

public class NewIdentityProviderHandlerParameterWizard
extends AbstractWizard<IdentityProviderHandlerParameter> {
    private final IdentityProviderHandlersTabEditor editor;

    public NewIdentityProviderHandlerParameterWizard(IdentityProviderHandlersTabEditor editor, FederationPresenter presenter) {
        super(IdentityProviderHandlerParameter.class, presenter, new String[]{"identity-provider", "handler", "handler-parameter"}, "value");
        this.editor = editor;
    }

    @Override
    protected void doSaveWizard(IdentityProviderHandlerParameter newHandlerParameter) {
        IdentityProviderHandlerTable handlerTable = this.editor.getHandlerTable();
        IdentityProviderHandler selectedHandler = handlerTable.getSelectedHandler();
        if (selectedHandler == null) {
            Console.error((String)"Please, choose a handler first.");
        } else if (newHandlerParameter != null && !newHandlerParameter.getName().trim().isEmpty()) {
            this.getPresenter().getFederationManager().onCreateIdentityProviderHandlerParameter(this.editor.getIdentityProvider().getIdentityProvider(), selectedHandler, newHandlerParameter);
            this.editor.getHandlerParameterTable().getDataProvider().getList().add(newHandlerParameter);
        }
    }

    @Override
    protected FormItem<?>[] doGetCustomFields() {
        TextBoxItem parameterName = new TextBoxItem("name", "Name");
        parameterName.setRequired(true);
        TextBoxItem parameterValue = new TextBoxItem("value", "Value");
        parameterValue.setRequired(true);
        return new FormItem[]{parameterName, parameterValue};
    }

    @Override
    protected String doGetTitle() {
        return "Add SAML Handler Parameter";
    }

    @Override
    public void edit(IdentityProviderHandlerParameter object) {
    }
}

