/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.widgets.ContentDescription;
import org.jboss.ballroom.client.widgets.tools.ToolButton;
import org.jboss.ballroom.client.widgets.tools.ToolStrip;
import org.jboss.ballroom.client.widgets.window.Feedback;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.i18n.PicketLinkUIMessages;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProvider;
import org.picketlink.as.console.client.shared.subsys.model.TrustDomain;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.idp.NewTrustDomainWizard;
import org.picketlink.as.console.client.ui.federation.idp.TrustDomainTable;

public class TrustedDomainTabEditor {
    private TrustDomainTable trustDomainTable;
    private FederationPresenter presenter;
    private IdentityProvider identityProvider;
    private ToolButton removeTrustedDomainBtn;
    private ToolButton addTrustedDomainBtn;
    private PicketLinkUIConstants uiConstants;
    private PicketLinkUIMessages uiMessages;

    public TrustedDomainTabEditor(FederationPresenter presenter, PicketLinkUIConstants uiConstants, PicketLinkUIMessages uiMessages) {
        this.presenter = presenter;
        this.uiConstants = uiConstants;
        this.uiMessages = uiMessages;
    }

    public Widget asWidget() {
        VerticalPanel trustDomainsHeader = new VerticalPanel();
        trustDomainsHeader.setStyleName("fill-layout-width");
        this.addTrustDomainActions(trustDomainsHeader);
        this.addTrustDomainTable(trustDomainsHeader);
        return trustDomainsHeader;
    }

    private void addTrustDomainTable(VerticalPanel detailPanel) {
        detailPanel.add(this.getTrustDomainTable().asWidget());
    }

    private void addTrustDomainActions(VerticalPanel trustDomainsHeader) {
        ToolStrip trustDomainTools = new ToolStrip();
        final TrustedDomainTabEditor editor = this;
        this.addTrustedDomainBtn = new ToolButton(Console.CONSTANTS.common_label_add());
        this.addTrustedDomainBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                new NewTrustDomainWizard(editor, TrustedDomainTabEditor.this.presenter, TrustedDomainTabEditor.this.uiConstants).launchWizard();
            }
        });
        trustDomainTools.addToolButtonRight(this.addTrustedDomainBtn);
        this.removeTrustedDomainBtn = new ToolButton(Console.CONSTANTS.common_label_delete());
        this.removeTrustedDomainBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final TrustDomain removedTrustedDomain = TrustedDomainTabEditor.this.getTrustDomainTable().getSelectedTrustedDomain();
                Feedback.confirm((String)Console.MESSAGES.deleteTitle(TrustedDomainTabEditor.this.uiConstants.common_label_trustDomain()), (String)Console.MESSAGES.deleteConfirm(removedTrustedDomain.getName()), (Feedback.ConfirmationHandler)new Feedback.ConfirmationHandler(){

                    public void onConfirmation(boolean isConfirmed) {
                        if (isConfirmed) {
                            TrustedDomainTabEditor.this.presenter.getFederationManager().onRemoveTrustDomain(TrustedDomainTabEditor.this.identityProvider, removedTrustedDomain);
                            TrustedDomainTabEditor.this.getTrustDomainTable().getDataProvider().getList().remove(removedTrustedDomain);
                        }
                    }
                });
            }
        });
        trustDomainTools.addToolButtonRight(this.removeTrustedDomainBtn);
        trustDomainTools.setStyleName("fill-layout-width");
        trustDomainsHeader.add((Widget)trustDomainTools);
        trustDomainsHeader.add((Widget)new ContentDescription(""));
    }

    public TrustDomainTable getTrustDomainTable() {
        if (this.trustDomainTable == null) {
            this.trustDomainTable = new TrustDomainTable();
        }
        return this.trustDomainTable;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        if (identityProvider == null || identityProvider.isExternal()) {
            this.addTrustedDomainBtn.setEnabled(false);
            this.removeTrustedDomainBtn.setEnabled(false);
        } else {
            this.addTrustedDomainBtn.setEnabled(true);
            this.removeTrustedDomainBtn.setEnabled(true);
        }
        this.identityProvider = identityProvider;
    }

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }
}

