/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.inject.Inject;
import java.util.List;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.domain.model.SimpleCallback;
import org.jboss.as.console.client.shared.deployment.DeploymentStore;
import org.jboss.as.console.client.shared.deployment.model.DeploymentRecord;
import org.jboss.ballroom.client.widgets.window.Feedback;
import org.jboss.dmr.client.ModelNode;
import org.jboss.dmr.client.dispatch.impl.DMRResponse;
import org.picketlink.as.console.client.shared.subsys.model.DeploymentFederationStore;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProvider;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProvider;
import org.picketlink.as.console.client.ui.federation.DeploymentCallback;

public class DeploymentManager {
    private DeploymentStore deploymentStore;
    private DeploymentFederationStore deploymentFederationStore;

    @Inject
    public DeploymentManager(DeploymentFederationStore deploymentFederationStore, DeploymentStore deploymentStore) {
        this.deploymentFederationStore = deploymentFederationStore;
        this.deploymentStore = deploymentStore;
    }

    public void restartIdentityProvider(IdentityProvider identityProvider) {
        identityProvider.setName(identityProvider.getName());
        identityProvider.setRuntimeName(identityProvider.getName());
        this.redeployDeployment(identityProvider);
    }

    public void restartServiceProvider(ServiceProvider serviceProvider) {
        serviceProvider.setName(serviceProvider.getName());
        serviceProvider.setRuntimeName(serviceProvider.getName());
        this.redeployDeployment(serviceProvider);
    }

    public void loadDeployments(final DeploymentCallback callback) {
        this.deploymentStore.loadDeployments((AsyncCallback)new SimpleCallback<List<DeploymentRecord>>(){

            public void onSuccess(List<DeploymentRecord> result) {
                callback.onLoadDeployments(result);
            }
        });
    }

    public void redeployDeployment(final DeploymentRecord record) {
        final PopupPanel loading = Feedback.loading((String)Console.CONSTANTS.common_label_plaseWait(), (String)Console.CONSTANTS.common_label_requestProcessed(), (Feedback.LoadingCallback)new Feedback.LoadingCallback(){

            public void onCancel() {
            }
        });
        this.deploymentFederationStore.redeploy(record, (AsyncCallback<DMRResponse>)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse response) {
                loading.hide();
                ModelNode result = response.get();
                if (result.isFailure()) {
                    Console.error((String)("Could not undeploy the deployment " + record.getName() + ". Make sure it is deployed and check the logs."));
                    Console.error((String)Console.MESSAGES.modificationFailed("Deployment " + record.getRuntimeName()), (String)result.getFailureDescription());
                } else {
                    Console.info((String)Console.MESSAGES.modified("Deployment " + record.getRuntimeName()));
                }
            }
        });
    }

    public void undeployDeployment(final DeploymentRecord record, final SimpleCallback<Boolean> callback) {
        final PopupPanel loading = Feedback.loading((String)Console.CONSTANTS.common_label_plaseWait(), (String)Console.CONSTANTS.common_label_requestProcessed(), (Feedback.LoadingCallback)new Feedback.LoadingCallback(){

            public void onCancel() {
            }
        });
        this.deploymentFederationStore.undeploy(record, (AsyncCallback<DMRResponse>)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse response) {
                loading.hide();
                ModelNode result = response.get();
                if (result.isFailure()) {
                    Console.error((String)("Could not undeploy the deployment " + record.getName() + ". Make sure it is deployed and check the logs."));
                    Console.error((String)Console.MESSAGES.modificationFailed("Deployment " + record.getRuntimeName()), (String)result.getFailureDescription());
                    callback.onSuccess((Object)false);
                } else {
                    Console.info((String)Console.MESSAGES.modified("Deployment " + record.getRuntimeName()));
                    callback.onSuccess((Object)true);
                }
            }
        });
    }
}

