/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.shared.subsys.model.TrustDomain;
import org.picketlink.as.console.client.ui.federation.AbstractWizard;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.idp.TrustedDomainTabEditor;

public class NewTrustDomainWizard
extends AbstractWizard<TrustDomain> {
    private final TrustedDomainTabEditor editor;
    private final PicketLinkUIConstants uiConstants;

    public NewTrustDomainWizard(TrustedDomainTabEditor editor, FederationPresenter presenter, PicketLinkUIConstants uiConstants) {
        super(TrustDomain.class, presenter, new String[]{"identity-provider", "trust-domain"}, "name");
        this.editor = editor;
        this.uiConstants = uiConstants;
    }

    @Override
    protected void doSaveWizard(TrustDomain newTrustedDomain) {
        if (newTrustedDomain != null && !newTrustedDomain.getName().trim().isEmpty()) {
            this.getPresenter().getFederationManager().onCreateTrustDomain(this.editor.getIdentityProvider(), newTrustedDomain);
            this.editor.getTrustDomainTable().getDataProvider().getList().add(newTrustedDomain);
        }
    }

    @Override
    protected FormItem<?>[] doGetCustomFields() {
        TextBoxItem name = new TextBoxItem("name", this.uiConstants.common_label_domainName());
        name.setRequired(true);
        return new FormItem[]{name};
    }

    @Override
    protected String doGetTitle() {
        return "Add Trust Domain";
    }

    @Override
    public void edit(TrustDomain object) {
    }
}

