/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.sp;

import org.jboss.as.console.client.Console;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandler;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandlerParameter;
import org.picketlink.as.console.client.ui.federation.AbstractWizard;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderHandlerParameterTable;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderHandlersTabEditor;

public class NewServiceProviderHandlerParameterWizard
extends AbstractWizard<ServiceProviderHandlerParameter> {
    private final ServiceProviderHandlersTabEditor editor;

    public NewServiceProviderHandlerParameterWizard(ServiceProviderHandlersTabEditor editor, FederationPresenter presenter) {
        super(ServiceProviderHandlerParameter.class, presenter, new String[]{"service-provider", "handler", "handler-parameter"}, "value");
        this.editor = editor;
    }

    @Override
    protected void doSaveWizard(ServiceProviderHandlerParameter newHandlerParameter) {
        ServiceProviderHandlerParameterTable handlerTable = this.editor.getHandlerParameterTable();
        ServiceProviderHandler selectedHandler = this.editor.getHandlerTable().getSelectedHandler();
        if (selectedHandler == null) {
            Console.error((String)"Please, choose a handler first.");
        } else if (newHandlerParameter != null && !newHandlerParameter.getName().trim().isEmpty()) {
            this.getPresenter().getFederationManager().onCreateServiceProviderHandlerParameter(this.editor.getServiceProvider().getServiceProvider(), selectedHandler, newHandlerParameter);
            handlerTable.getDataProvider().getList().add(newHandlerParameter);
        }
    }

    @Override
    protected FormItem<?>[] doGetCustomFields() {
        TextBoxItem parameterName = new TextBoxItem("name", "Name");
        parameterName.setRequired(true);
        TextBoxItem parameterValue = new TextBoxItem("value", "Value");
        parameterValue.setRequired(true);
        return new FormItem[]{parameterName, parameterValue};
    }

    @Override
    protected String doGetTitle() {
        return "Add SAML Handler Parameter";
    }

    @Override
    public void edit(ServiceProviderHandlerParameter object) {
    }
}

