/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.sp;

import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.List;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandler;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandlerWrapper;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderWrapper;
import org.picketlink.as.console.client.ui.federation.AbstractModelElementTable;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderHandlerParameterTable;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderHandlersTabEditor;

public class ServiceProviderHandlerTable
extends AbstractModelElementTable<ServiceProviderHandler> {
    private ServiceProviderWrapper selectedServiceProvider;
    private ServiceProviderHandler selectedHandler;
    private ServiceProviderHandlerParameterTable parametersTable;
    private FederationPresenter presenter;
    private ServiceProviderHandlersTabEditor handlersTabEditor;

    @Override
    protected Object doGetKey(ServiceProviderHandler item) {
        return item.getClassName();
    }

    @Override
    protected void doAddColumns(CellTable table) {
        this.createNameColumn(table);
        this.getCellTable().setSelectionModel(this.createSelectionModel());
    }

    private SingleSelectionModel<ServiceProviderHandler> createSelectionModel() {
        SingleSelectionModel selectionModel = new SingleSelectionModel();
        SelectionChangeEvent.Handler selectionHandler = new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                SingleSelectionModel selection = (SingleSelectionModel)event.getSource();
                ServiceProviderHandlerTable.this.selectedHandler = (ServiceProviderHandler)selection.getSelectedObject();
                List<ServiceProviderHandlerWrapper> handlers = ServiceProviderHandlerTable.this.selectedServiceProvider.getHandlers();
                for (ServiceProviderHandlerWrapper handlerWrapper : handlers) {
                    if (!handlerWrapper.getHandler().getClassName().equals(ServiceProviderHandlerTable.this.selectedHandler.getClassName())) continue;
                    ServiceProviderHandlerTable.this.parametersTable.getDataProvider().setList(handlerWrapper.getParameters());
                }
                ServiceProviderHandlerTable.this.handlersTabEditor.doUpdateSelection(ServiceProviderHandlerTable.this.selectedHandler);
            }
        };
        selectionModel.addSelectionChangeHandler(selectionHandler);
        return selectionModel;
    }

    private void createNameColumn(CellTable table) {
        TextColumn<ServiceProviderHandler> nameColumn = new TextColumn<ServiceProviderHandler>(){

            public String getValue(ServiceProviderHandler record) {
                return record.getClassName();
            }
        };
        table.addColumn((Column)nameColumn, "Class Name");
    }

    public ServiceProviderHandler getSelectedHandler() {
        return this.selectedHandler;
    }

    public void setParametersTable(ServiceProviderHandlerParameterTable parametersTable) {
        this.parametersTable = parametersTable;
    }

    public void setPresenter(FederationPresenter presenter) {
        this.presenter = presenter;
    }

    public void setSelectedServiceProvider(ServiceProviderWrapper selectedServiceProvider) {
        this.selectedServiceProvider = selectedServiceProvider;
    }

    public void setHandlersTabEditor(ServiceProviderHandlersTabEditor handlersTabEditor) {
        this.handlersTabEditor = handlersTabEditor;
    }
}

