/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation;

import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.VerticalPanel;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.as.console.client.domain.model.SimpleCallback;
import org.jboss.as.console.client.shared.help.StaticHelpPanel;
import org.jboss.as.console.client.shared.subsys.Baseadress;
import org.jboss.as.console.client.shared.subsys.security.SecurityDomainsPresenter;
import org.jboss.dmr.client.ModelNode;
import org.jboss.dmr.client.dispatch.Action;
import org.jboss.dmr.client.dispatch.impl.DMRAction;
import org.jboss.dmr.client.dispatch.impl.DMRResponse;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;

public class AsyncHelpText
implements SecurityDomainsPresenter.DescriptionCallBack {
    private final VerticalPanel layout;
    private boolean isDialogue;
    private String[] type;
    private String[] attributesNames;
    private FederationPresenter presenter;

    public AsyncHelpText(String[] type, String[] attributesNames, FederationPresenter presenter, VerticalPanel layout, boolean isDialogue) {
        this.layout = layout;
        this.type = type;
        this.attributesNames = attributesNames;
        this.presenter = presenter;
        this.getDescription(this.type, this);
        this.isDialogue = isDialogue;
    }

    public AsyncHelpText(String type, String[] attributesNames, FederationPresenter presenter, VerticalPanel layout, boolean isDialogue) {
        this(new String[]{type}, attributesNames, presenter, layout, isDialogue);
    }

    public void setDescription(ModelNode desc) {
        SafeHtmlBuilder builder = new SafeHtmlBuilder();
        if (desc.get("description").isDefined()) {
            builder.appendEscaped(desc.get("description").asString());
            builder.appendHtmlConstant("<p/>");
        }
        ArrayList<String> attrs = new ArrayList<String>(Arrays.asList(this.attributesNames));
        ModelNode values = desc.get("attributes");
        builder.appendHtmlConstant("<ul>");
        for (String s : attrs) {
            builder.appendHtmlConstant("<li><b>");
            builder.appendEscaped(s);
            builder.appendHtmlConstant("</b> - ");
            builder.appendEscaped(values.get(new String[]{s, "description"}).asString());
        }
        builder.appendHtmlConstant("</ul>");
        SafeHtml safeHtml = builder.toSafeHtml();
        StaticHelpPanel helpPanel = new StaticHelpPanel(safeHtml);
        this.layout.insert(helpPanel.asWidget(), this.isDialogue ? 0 : 1);
    }

    private void getDescription(String[] types, final SecurityDomainsPresenter.DescriptionCallBack callback) {
        ModelNode operation = this.createOperation("read-resource-description");
        operation.get("address").add("federation", "federation");
        for (String type : types) {
            operation.get("address").add(type, type);
        }
        this.presenter.getDispatchAsync().execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (!response.hasDefined("result")) {
                    return;
                }
                callback.setDescription(response.get("result"));
            }
        });
    }

    private ModelNode createOperation(String operator) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set(operator);
        operation.get("address").set(Baseadress.get());
        operation.get("address").add("subsystem", "picketlink-federation");
        return operation;
    }
}

