/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.widgets.ContentDescription;
import org.jboss.ballroom.client.widgets.ContentHeaderLabel;
import org.jboss.ballroom.client.widgets.tools.ToolButton;
import org.jboss.ballroom.client.widgets.tools.ToolStrip;
import org.jboss.ballroom.client.widgets.window.Feedback;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.i18n.PicketLinkUIMessages;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandler;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandlerParameter;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandlerWrapper;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderWrapper;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderHandlerParameterTable;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderHandlerTable;
import org.picketlink.as.console.client.ui.federation.idp.NewIdentityProviderHandlerParameterWizard;
import org.picketlink.as.console.client.ui.federation.idp.NewIdentityProviderHandlerWizard;

public class IdentityProviderHandlersTabEditor {
    private IdentityProviderHandlerTable handlerTable;
    private IdentityProviderHandlerParameterTable handlerParameterTable;
    private FederationPresenter presenter;
    private IdentityProviderWrapper identityProvider;
    private ToolButton removeHandlerBtn;
    private ToolButton addHandlerBtn;
    private ToolButton removeHandlerParameterBtn;
    private ToolButton addHandlerParameterBtn;
    private PicketLinkUIConstants uiConstants;
    private PicketLinkUIMessages uiMessages;

    public IdentityProviderHandlersTabEditor(FederationPresenter presenter, PicketLinkUIConstants uiConstants, PicketLinkUIMessages uiMessages) {
        this.presenter = presenter;
        this.uiConstants = uiConstants;
        this.uiMessages = uiMessages;
    }

    public Widget asWidget() {
        VerticalPanel trustDomainsHeader = new VerticalPanel();
        trustDomainsHeader.setStyleName("fill-layout-width");
        trustDomainsHeader.add((Widget)new ContentHeaderLabel("Handler"));
        this.addHandlerActions(trustDomainsHeader);
        this.addHandlerTable(trustDomainsHeader);
        trustDomainsHeader.add((Widget)new ContentHeaderLabel("Handler Parameters"));
        this.addHandlerParameterActions(trustDomainsHeader);
        trustDomainsHeader.add(this.getHandlerParameterTable().asWidget());
        return trustDomainsHeader;
    }

    private void addHandlerTable(VerticalPanel detailPanel) {
        detailPanel.add(this.getHandlerTable().asWidget());
    }

    private void addHandlerActions(VerticalPanel trustDomainsHeader) {
        ToolStrip trustDomainTools = new ToolStrip();
        final IdentityProviderHandlersTabEditor editor = this;
        this.addHandlerBtn = new ToolButton(Console.CONSTANTS.common_label_add());
        this.addHandlerBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                new NewIdentityProviderHandlerWizard(editor, IdentityProviderHandlersTabEditor.this.presenter).launchWizard();
            }
        });
        trustDomainTools.addToolButtonRight(this.addHandlerBtn);
        this.removeHandlerBtn = new ToolButton(Console.CONSTANTS.common_label_delete());
        this.removeHandlerBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final IdentityProviderHandler removedTrustedDomain = IdentityProviderHandlersTabEditor.this.getHandlerTable().getSelectedHandler();
                Feedback.confirm((String)Console.MESSAGES.deleteTitle("SAML Handler"), (String)Console.MESSAGES.deleteConfirm(removedTrustedDomain.getClassName()), (Feedback.ConfirmationHandler)new Feedback.ConfirmationHandler(){

                    public void onConfirmation(boolean isConfirmed) {
                        if (isConfirmed) {
                            IdentityProviderHandlersTabEditor.this.presenter.getFederationManager().onRemoveIdentityProviderHandler(IdentityProviderHandlersTabEditor.this.identityProvider.getIdentityProvider(), removedTrustedDomain);
                            IdentityProviderHandlersTabEditor.this.getHandlerTable().getDataProvider().getList().remove(removedTrustedDomain);
                            IdentityProviderHandlersTabEditor.this.getHandlerParameterTable().getDataProvider().getList().clear();
                        }
                    }
                });
            }
        });
        trustDomainTools.addToolButtonRight(this.removeHandlerBtn);
        trustDomainTools.setStyleName("fill-layout-width");
        trustDomainsHeader.add((Widget)trustDomainTools);
        trustDomainsHeader.add((Widget)new ContentDescription(""));
    }

    private void addHandlerParameterActions(VerticalPanel trustDomainsHeader) {
        ToolStrip trustDomainTools = new ToolStrip();
        final IdentityProviderHandlersTabEditor editor = this;
        this.addHandlerParameterBtn = new ToolButton(Console.CONSTANTS.common_label_add());
        this.addHandlerParameterBtn.setEnabled(false);
        this.addHandlerParameterBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                new NewIdentityProviderHandlerParameterWizard(editor, IdentityProviderHandlersTabEditor.this.presenter).launchWizard();
            }
        });
        trustDomainTools.addToolButtonRight(this.addHandlerParameterBtn);
        this.removeHandlerParameterBtn = new ToolButton(Console.CONSTANTS.common_label_delete());
        this.removeHandlerParameterBtn.setEnabled(false);
        this.removeHandlerParameterBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final IdentityProviderHandlerParameter removedHandlerParameter = IdentityProviderHandlersTabEditor.this.getHandlerParameterTable().getSelectedHandlerParameter();
                Feedback.confirm((String)Console.MESSAGES.deleteTitle("Handler Parameter"), (String)Console.MESSAGES.deleteConfirm(removedHandlerParameter.getName()), (Feedback.ConfirmationHandler)new Feedback.ConfirmationHandler(){

                    public void onConfirmation(boolean isConfirmed) {
                        if (isConfirmed) {
                            IdentityProviderHandlersTabEditor.this.presenter.getFederationManager().onRemoveIdentityProviderHandlerParameter(IdentityProviderHandlersTabEditor.this.identityProvider.getIdentityProvider(), IdentityProviderHandlersTabEditor.this.getHandlerTable().getSelectedHandler(), removedHandlerParameter);
                            IdentityProviderHandlersTabEditor.this.getHandlerParameterTable().getDataProvider().getList().remove(removedHandlerParameter);
                        }
                    }
                });
            }
        });
        trustDomainTools.addToolButtonRight(this.removeHandlerParameterBtn);
        trustDomainTools.setStyleName("fill-layout-width");
        trustDomainsHeader.add((Widget)trustDomainTools);
        trustDomainsHeader.add((Widget)new ContentDescription(""));
    }

    public IdentityProviderHandlerTable getHandlerTable() {
        if (this.handlerTable == null) {
            this.handlerTable = new IdentityProviderHandlerTable();
            this.handlerTable.setParametersTable(this.getHandlerParameterTable());
            this.handlerTable.setHandlersTabEditor(this);
        }
        return this.handlerTable;
    }

    public IdentityProviderHandlerParameterTable getHandlerParameterTable() {
        if (this.handlerParameterTable == null) {
            this.handlerParameterTable = new IdentityProviderHandlerParameterTable();
        }
        return this.handlerParameterTable;
    }

    private void showRestartDialog() {
        if (Window.confirm((String)"Changes would be applied after a restart. Do you want to do it now ?")) {
            this.presenter.getDeploymentManager().restartIdentityProvider(this.identityProvider.getIdentityProvider());
        }
    }

    public void setIdentityProvider(IdentityProviderWrapper identityProvider) {
        if (identityProvider == null || identityProvider.getIdentityProvider().isExternal()) {
            this.addHandlerBtn.setEnabled(false);
            this.removeHandlerBtn.setEnabled(false);
        } else {
            this.addHandlerBtn.setEnabled(true);
            this.removeHandlerBtn.setEnabled(true);
        }
        this.identityProvider = identityProvider;
        this.getHandlerTable().setSelectedIdentityProvider(this.identityProvider);
    }

    public void doUpdateSelection(IdentityProviderHandler selectedHandler) {
        List<IdentityProviderHandlerWrapper> handlers = this.identityProvider.getHandlers();
        if (handlers.isEmpty()) {
            this.enableDisableHandlerParameterActions(false);
        }
        ArrayList<IdentityProviderHandlerParameter> parameters = new ArrayList<IdentityProviderHandlerParameter>();
        for (IdentityProviderHandlerWrapper handlerWrapper : handlers) {
            if (!handlerWrapper.getHandler().getClassName().equals(selectedHandler.getClassName())) continue;
            for (IdentityProviderHandlerParameter serviceProviderHandlerParameter : handlerWrapper.getParameters()) {
                parameters.add(serviceProviderHandlerParameter);
            }
        }
        this.getHandlerParameterTable().getDataProvider().setList(parameters);
    }

    public IdentityProviderWrapper getIdentityProvider() {
        return this.identityProvider;
    }

    public void enableDisableHandlerParameterActions(boolean enable) {
        this.addHandlerParameterBtn.setEnabled(enable);
        this.removeHandlerParameterBtn.setEnabled(enable);
        if (this.getHandlerParameterTable().getDataProvider().getList().isEmpty()) {
            this.removeHandlerParameterBtn.setEnabled(false);
        }
    }
}

