/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.sp;

import java.util.ArrayList;
import org.jboss.ballroom.client.widgets.forms.ComboBoxItem;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.picketlink.as.console.client.shared.subsys.model.HandlerTypeEnum;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandler;
import org.picketlink.as.console.client.ui.federation.AbstractWizard;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderHandlersTabEditor;

public class NewServiceProviderHandlerWizard
extends AbstractWizard<ServiceProviderHandler> {
    private final ServiceProviderHandlersTabEditor editor;
    private TextBoxItem className;
    private ComboBoxItem code;

    public NewServiceProviderHandlerWizard(ServiceProviderHandlersTabEditor editor, FederationPresenter presenter) {
        super(ServiceProviderHandler.class, presenter, new String[]{"service-provider", "handler"}, "class-name");
        this.editor = editor;
    }

    @Override
    protected void doSaveWizard(ServiceProviderHandler newHandler) {
        String code = newHandler.getCode();
        String className = newHandler.getClassName();
        if (!code.trim().isEmpty() || !className.trim().isEmpty()) {
            if (HandlerTypeEnum.find(code) == null) {
                newHandler.setCode(null);
            } else {
                newHandler.setClassName(null);
            }
            this.getPresenter().getFederationManager().onCreateServiceProviderHandler(this.editor.getServiceProvider().getServiceProvider(), newHandler);
            this.editor.getHandlerTable().getDataProvider().getList().add(newHandler);
        }
    }

    @Override
    protected FormItem<?>[] doGetCustomFields() {
        TextBoxItem name = new TextBoxItem("name", "Name");
        name.setRequired(true);
        this.className = new TextBoxItem("className", "Class Name"){

            public void setUndefined(boolean undefined) {
                NewServiceProviderHandlerWizard.this.code.setEnabled(undefined);
                NewServiceProviderHandlerWizard.this.code.setRequired(undefined);
                if (!undefined) {
                    NewServiceProviderHandlerWizard.this.code.setValue("");
                }
            }
        };
        this.className.setRequired(true);
        this.code = new ComboBoxItem("code", "Code"){

            public void setUndefined(boolean undefined) {
                NewServiceProviderHandlerWizard.this.className.setEnabled(undefined);
                NewServiceProviderHandlerWizard.this.className.setRequired(undefined);
                if (!undefined) {
                    NewServiceProviderHandlerWizard.this.className.setValue("");
                }
            }
        };
        ArrayList<String> handlerTypes = new ArrayList<String>();
        for (HandlerTypeEnum handlerType : HandlerTypeEnum.values()) {
            handlerTypes.add(handlerType.getAlias());
        }
        this.code.setValueMap(handlerTypes);
        return new FormItem[]{name, this.code, this.className};
    }

    @Override
    protected String doGetTitle() {
        return "Add SAML Handler";
    }

    @Override
    public void edit(ServiceProviderHandler object) {
    }
}

