/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.saml.v2.response;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import org.picketlink.identity.federation.api.saml.v2.response.SecurityActions;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.picketlink.identity.federation.core.saml.v2.factories.JBossSAMLAuthnResponseFactory;
import org.picketlink.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.picketlink.identity.federation.core.saml.v2.factories.SAMLProtocolFactory;
import org.picketlink.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.JAXBElementMappingUtil;
import org.picketlink.identity.federation.core.util.JAXBUtil;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.assertion.ActionType;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthzDecisionStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.DecisionType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.picketlink.identity.federation.saml.v2.assertion.EvidenceType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.ObjectFactory;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML2Response {
    private SAMLDocumentHolder samlDocumentHolder = null;

    public AssertionType createAssertion(String id, NameIDType issuer) {
        return AssertionUtil.createAssertion((String)id, (NameIDType)issuer);
    }

    public AuthnStatementType createAuthnStatement(String authnContextDeclRef, XMLGregorianCalendar issueInstant) {
        ObjectFactory objectFactory = SAMLAssertionFactory.getObjectFactory();
        AuthnStatementType authnStatement = objectFactory.createAuthnStatementType();
        authnStatement.setAuthnInstant(issueInstant);
        AuthnContextType act = objectFactory.createAuthnContextType();
        String authContextDeclRef = JBossSAMLURIConstants.AC_PASSWORD_PROTECTED_TRANSPORT.get();
        act.getContent().add(objectFactory.createAuthnContextDeclRef(authContextDeclRef));
        authnStatement.setAuthnContext(act);
        return authnStatement;
    }

    public AuthzDecisionStatementType createAuthzDecisionStatementType(String resource, DecisionType decision, EvidenceType evidence, ActionType ... actions) {
        ObjectFactory objectFactory = SAMLAssertionFactory.getObjectFactory();
        AuthzDecisionStatementType authzDecST = objectFactory.createAuthzDecisionStatementType();
        authzDecST.setResource(resource);
        authzDecST.setDecision(decision);
        if (evidence != null) {
            authzDecST.setEvidence(evidence);
        }
        if (actions != null) {
            authzDecST.getAction().addAll(Arrays.asList(actions));
        }
        return authzDecST;
    }

    public ResponseType createResponseType(String ID, SPInfoHolder sp, IDPInfoHolder idp, IssuerInfoHolder issuerInfo) throws ConfigurationException {
        return JBossSAMLAuthnResponseFactory.createResponseType((String)ID, (SPInfoHolder)sp, (IDPInfoHolder)idp, (IssuerInfoHolder)issuerInfo);
    }

    public ResponseType createResponseType() {
        return JBossSAMLAuthnResponseFactory.createResponseType();
    }

    public ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, AssertionType assertion) throws ConfigurationException {
        return JBossSAMLAuthnResponseFactory.createResponseType((String)ID, (IssuerInfoHolder)issuerInfo, (AssertionType)assertion);
    }

    public void createTimedConditions(AssertionType assertion, long durationInMilis) throws ConfigurationException, IssueInstantMissingException {
        AssertionUtil.createTimedConditions((AssertionType)assertion, (long)durationInMilis);
    }

    public EncryptedElementType getEncryptedAssertion(InputStream is) throws JAXBException, SAXException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        Unmarshaller un = JBossSAMLAuthnResponseFactory.getUnmarshaller();
        JAXBElement jaxb = (JAXBElement)un.unmarshal(is);
        return (EncryptedElementType)jaxb.getValue();
    }

    public AssertionType getAssertionType(InputStream is) throws JAXBException, SAXException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        Unmarshaller un = JBossSAMLAuthnResponseFactory.getUnmarshaller();
        JAXBElement jaxb = (JAXBElement)un.unmarshal(is);
        return (AssertionType)jaxb.getValue();
    }

    public SAMLDocumentHolder getSamlDocumentHolder() {
        return this.samlDocumentHolder;
    }

    public ResponseType getResponseType(InputStream is) throws ParsingException, ConfigurationException, ProcessingException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        Document samlResponseDocument = DocumentUtil.getDocument((InputStream)is);
        try {
            Binder<Node> binder = this.getBinder();
            JAXBElement jaxbResponseType = (JAXBElement)binder.unmarshal((Object)samlResponseDocument);
            ResponseType responseType = (ResponseType)jaxbResponseType.getValue();
            this.samlDocumentHolder = new SAMLDocumentHolder((SAML2Object)responseType, samlResponseDocument);
            return responseType;
        }
        catch (JAXBException e) {
            throw new ParsingException((Throwable)e);
        }
    }

    public SAML2Object getSAML2ObjectFromStream(InputStream is) throws ParsingException, ConfigurationException, ProcessingException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        Document samlResponseDocument = DocumentUtil.getDocument((InputStream)is);
        try {
            Binder<Node> binder = this.getBinder();
            JAXBElement saml2Object = (JAXBElement)binder.unmarshal((Object)samlResponseDocument);
            SAML2Object responseType = (SAML2Object)saml2Object.getValue();
            this.samlDocumentHolder = new SAMLDocumentHolder(responseType, samlResponseDocument);
            return responseType;
        }
        catch (JAXBException e) {
            throw new ParsingException((Throwable)e);
        }
    }

    public Document convert(EncryptedElementType encryptedElementType) throws JAXBException, ConfigurationException {
        JAXBContext jaxb = JAXBUtil.getJAXBContext(EncryptedElementType.class);
        Binder binder = jaxb.createBinder();
        Document doc = DocumentUtil.createDocument();
        binder.marshal((Object)JAXBElementMappingUtil.get((EncryptedElementType)encryptedElementType), (Object)doc);
        return doc;
    }

    public Binder<Node> getBinder() throws JAXBException {
        JAXBContext jaxb = JAXBUtil.getJAXBContext(ResponseType.class);
        return jaxb.createBinder();
    }

    public Document convert(StatusResponseType responseType) throws JAXBException, ConfigurationException {
        JAXBContext jaxb = JAXBUtil.getJAXBContext(StatusResponseType.class);
        Binder binder = jaxb.createBinder();
        Document responseDocument = DocumentUtil.createDocument();
        binder.marshal((Object)JAXBElementMappingUtil.get((StatusResponseType)responseType), (Object)responseDocument);
        return responseDocument;
    }

    public void marshall(ResponseType responseType, OutputStream os) throws JAXBException, SAXException {
        String key = "org.picketlink.jaxb.schema.validation";
        boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
        Marshaller marshaller = JBossSAMLAuthnResponseFactory.getValidatingMarshaller((boolean)validate);
        JAXBElement jaxb = SAMLProtocolFactory.getObjectFactory().createResponse(responseType);
        marshaller.marshal((Object)jaxb, os);
    }

    public void marshall(ResponseType responseType, Writer writer) throws JAXBException, SAXException {
        Marshaller marshaller = JBossSAMLAuthnResponseFactory.getMarshaller();
        JAXBElement jaxb = SAMLProtocolFactory.getObjectFactory().createResponse(responseType);
        marshaller.marshal((Object)jaxb, writer);
    }
}

