/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.util;

import java.io.Reader;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.picketlink.identity.federation.core.util.Base64;
import org.picketlink.identity.federation.core.util.JAXBUtil;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.picketlink.identity.xmlsec.w3.xmldsig.ObjectFactory;

public class KeyUtil {
    private static String EOL = KeyUtil.getSystemProperty("line.separator", "\n");
    private static ObjectFactory of = new ObjectFactory();

    public static String encodeAsString(Certificate certificate) throws CertificateEncodingException {
        return Base64.encodeBytes((byte[])certificate.getEncoded());
    }

    public static KeyInfoType getKeyInfo(Certificate certificate) throws JAXBException, CertificateException {
        if (certificate == null) {
            throw new IllegalArgumentException("certificate is null");
        }
        StringBuilder builder = new StringBuilder();
        if (!(certificate instanceof X509Certificate)) {
            throw new RuntimeException("NYI");
        }
        X509Certificate x509 = (X509Certificate)certificate;
        String certStr = Base64.encodeBytes((byte[])x509.getEncoded(), (int)76);
        builder.append("<KeyInfo xmlns='http://www.w3.org/2000/09/xmldsig#'>").append(EOL).append("<X509Data>").append(EOL).append("<X509Certificate>").append(EOL).append(certStr).append(EOL).append("</X509Certificate>").append("</X509Data>").append("</KeyInfo>");
        JAXBElement keyInfoJ = (JAXBElement)KeyUtil.getUnmarshaller().unmarshal((Reader)new StringReader(builder.toString()));
        return (KeyInfoType)keyInfoJ.getValue();
    }

    public static ObjectFactory getObjectFactory() {
        return of;
    }

    public static Unmarshaller getUnmarshaller() throws JAXBException {
        return JAXBUtil.getUnmarshaller((String)"org.picketlink.identity.xmlsec.w3.xmldsig");
    }

    public static Marshaller getMarshaller() throws JAXBException {
        return JAXBUtil.getMarshaller((String)"org.picketlink.identity.xmlsec.w3.xmldsig");
    }

    static String getSystemProperty(final String key, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }
}

