/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.wstrust;

import java.net.ConnectException;
import java.net.URI;
import java.security.Principal;
import java.util.List;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientFactory;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenCollection;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSTrustClient {
    private STSClient[] clients;

    public WSTrustClient(String serviceName, String port, String endpointURI, SecurityInfo secInfo) throws ParsingException {
        this(serviceName, port, new String[]{endpointURI}, secInfo);
    }

    public WSTrustClient(String serviceName, String port, String[] endpointURIs, SecurityInfo secInfo) throws ParsingException {
        if (serviceName == null || port == null || endpointURIs == null || secInfo == null) {
            throw new IllegalArgumentException("The service name, port, endpoint URIs and security info parameters cannot be null");
        }
        if (endpointURIs.length == 0) {
            throw new IllegalArgumentException("At least one endpoint URI must be informed");
        }
        this.clients = new STSClient[endpointURIs.length];
        STSClientConfig.Builder builder = new STSClientConfig.Builder();
        builder.serviceName(serviceName).portName(port).username(secInfo.username).password(secInfo.passwd);
        int index = 0;
        for (String endpointURI : endpointURIs) {
            builder.endpointAddress(endpointURI);
            this.clients[index++] = STSClientFactory.getInstance().create(builder.build());
        }
    }

    public Element issueToken(String tokenType) throws WSTrustException {
        if (tokenType == null) {
            throw new IllegalArgumentException("The token type cannot be null");
        }
        RequestSecurityToken request = new RequestSecurityToken();
        request.setTokenType(URI.create(tokenType));
        return this.issueInternal(request, 0);
    }

    public Element issueTokenForEndpoint(String endpointURI) throws WSTrustException {
        if (endpointURI == null) {
            throw new IllegalArgumentException("The endpoint URI cannot be null");
        }
        RequestSecurityToken request = new RequestSecurityToken();
        request.setAppliesTo(WSTrustUtil.createAppliesTo((String)endpointURI));
        return this.issueInternal(request, 0);
    }

    public Element issueToken(String endpointURI, String tokenType) throws WSTrustException {
        if (endpointURI == null && tokenType == null) {
            throw new IllegalArgumentException("Either the token type or endpoint URI must be specified");
        }
        RequestSecurityToken request = new RequestSecurityToken();
        if (tokenType != null) {
            request.setTokenType(URI.create(tokenType));
        }
        if (endpointURI != null) {
            request.setAppliesTo(WSTrustUtil.createAppliesTo((String)endpointURI));
        }
        return this.issueInternal(request, 0);
    }

    public Element issueTokenOnBehalfOf(String endpointURI, String tokenType, Principal principal) throws WSTrustException {
        if (endpointURI == null && tokenType == null) {
            throw new IllegalArgumentException("Either the token type or endpoint URI must be specified");
        }
        if (principal == null) {
            throw new IllegalArgumentException("The on-behalf-of principal cannot be null");
        }
        RequestSecurityToken request = new RequestSecurityToken();
        if (tokenType != null) {
            request.setTokenType(URI.create(tokenType));
        }
        if (endpointURI != null) {
            request.setAppliesTo(WSTrustUtil.createAppliesTo((String)endpointURI));
        }
        request.setOnBehalfOf(WSTrustUtil.createOnBehalfOfWithUsername((String)principal.getName(), (String)"ID"));
        return this.issueInternal(request, 0);
    }

    public Element issueToken(RequestSecurityToken request) throws WSTrustException {
        if (request == null) {
            throw new IllegalArgumentException("The specified request cannot be null");
        }
        return this.issueInternal(request, 0);
    }

    public List<Element> issueTokens(RequestSecurityTokenCollection requestCollection) throws WSTrustException {
        if (requestCollection == null || requestCollection.getRequestSecurityTokens().size() == 0) {
            throw new IllegalArgumentException("The specified request collection must contain at least one request.");
        }
        return this.issueInternal(requestCollection, 0);
    }

    public Element renewToken(String tokenType, Element token) throws WSTrustException {
        return this.renewInternal(token, 0);
    }

    public Element renewToken(Element token) throws WSTrustException {
        return this.renewInternal(token, 0);
    }

    public List<Element> renewTokens(List<Element> tokens) throws WSTrustException {
        if (tokens == null || tokens.size() == 0) {
            throw new IllegalArgumentException("The specified list must contain at least one token for renewal");
        }
        return this.renewInternal(tokens, 0);
    }

    public boolean validateToken(Element token) throws WSTrustException {
        return this.validateInternal(token, 0);
    }

    public List<Boolean> validateTokens(List<Element> tokens) throws WSTrustException {
        if (tokens == null || tokens.size() == 0) {
            throw new IllegalArgumentException("The specified list must contain at least one token for validation");
        }
        return this.validateInternal(tokens, 0);
    }

    public boolean cancelToken(Element token) throws WSTrustException {
        return this.cancelInternal(token, 0);
    }

    public List<Boolean> cancelTokens(List<Element> tokens) throws WSTrustException {
        if (tokens == null || tokens.size() == 0) {
            throw new IllegalArgumentException("The specified list must contain at least one token");
        }
        return this.cancelInternal(tokens, 0);
    }

    private Element issueInternal(RequestSecurityToken request, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.issueToken(request);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.issueInternal(request, ++clientIndex);
            }
            throw e;
        }
    }

    private List<Element> issueInternal(RequestSecurityTokenCollection request, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.issueTokens(request);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.issueInternal(request, ++clientIndex);
            }
            throw e;
        }
    }

    private Element renewInternal(Element token, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.renewToken(token);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.renewInternal(token, ++clientIndex);
            }
            throw e;
        }
    }

    private List<Element> renewInternal(List<Element> tokens, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.renewTokens(tokens);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.renewInternal(tokens, ++clientIndex);
            }
            throw e;
        }
    }

    private boolean validateInternal(Element token, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.validateToken(token);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.validateInternal(token, ++clientIndex);
            }
            throw e;
        }
    }

    private List<Boolean> validateInternal(List<Element> tokens, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.validateTokens(tokens);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.validateInternal(tokens, ++clientIndex);
            }
            throw e;
        }
    }

    private boolean cancelInternal(Element token, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.cancelToken(token);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.cancelInternal(token, ++clientIndex);
            }
            throw e;
        }
    }

    private List<Boolean> cancelInternal(List<Element> tokens, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.cancelTokens(tokens);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.cancelInternal(tokens, ++clientIndex);
            }
            throw e;
        }
    }

    private boolean isCausedByConnectException(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable instanceof ConnectException && throwable.getMessage().equals("Connection refused");
    }

    public static class SecurityInfo {
        private String username;
        private String passwd;

        public SecurityInfo(String name, char[] pass) {
            this.username = name;
            this.passwd = new String(pass);
        }

        public SecurityInfo(String name, String pass) {
            this.username = name;
            this.passwd = pass;
        }
    }
}

